# -*- coding: iso-8859-1 -*-
"""
   PIL - Color2Gray ImageCorrection - Effect

   Color2Gray image correction algorithm implemented according to
   http://www.e56.de/c2g.php, copyrights by Martin Faust

   Please note:
   Color2Gray ImageCorrection needs Python Image Library (PIL)
   from http://www.pythonware.com/products/pil/

   You can call Color2Gray from the command-line with
   "testPILc2g.py C:\image.png True"

   @copyright: 2008 by Oliver Siemoneit
   @license: GNU GPL, see COPYING for details.
"""

import os.path

try:
    from PIL import Image
except:
    raise Exception("Unable to import Python Imaging Library")

try:
    import PILc2g
except:
    raise Exception("Unable to import PILc2g extension module")

if __name__ == "__main__":
    import sys
   
    print "Color2Gray image correction for color blind users"
    
    if len(sys.argv) != 3:
        print "Calling syntax: color2gray.py [fullpath to image file] [brightness_correction=True/False]"
        print "Example: testPILc2g.py C:/pic.png False"
        sys.exit(1)

    fpath = sys.argv[1]

    if not (os.path.isfile(fpath)):
        print "Given file does not exist"
        sys.exit(1)

    extpos = fpath.rfind(".")
    if not (extpos > 0 and fpath[extpos:].lower() in ['.gif', '.jpg', '.jpeg', '.png', '.bmp', '.ico', ]):
        print "Given file is not an image"
        sys.exit(1)

    brightness_correction = bool(sys.argv[2]=='True')

    path, fname = os.path.split(fpath)
    modified_fname = "%s-%s-%s" % ('color2gray', brightness_correction, fname)
    modified_fpath = os.path.join(path, modified_fname)

    if os.path.isfile(modified_fpath):
        print "Target file does already exist"
        sys.exit(1)

    im = Image.open(fpath)

    if im.mode in ['1', 'L']: 
        print "Given file is already a black/white or grayscale image"
        sys.exit(1)

    im = im.convert('RGB')
    im.load()

    imOut = Image.new(im.mode, im.size)

    import cProfile
    cProfile.run('PILc2g.c2g(im.im.id, imOut.im.id, int(brightness_correction))')

##    result = PILc2g.c2g(im.im.id, imOut.im.id, int(brightness_correction)) # XXX FixME Don't know how to pass a BOOL..
##    if result[0] != 0:
##        raise Exception, result[1]

    imOut.save(modified_fpath)

