# -*- coding: iso-8859-1 -*-
"""
   PIL - Daltonize ImageCorrection - Effect

   Daltonize image correction algorithm implemented according to
   http://scien.stanford.edu/class/psych221/projects/05/ofidaner/colorblindness_project.htm

   Please note:
   Daltonize ImageCorrection needs Python Image Library (PIL)
   from http://www.pythonware.com/products/pil/

   You can call Daltonize from the command-line with
   "testPILdaltonize.py [image] [mode]" e.g. "testPILdaltonize.py C:\image.png 1"

   with
   mode = 1: image correction for deuteranopia (unable to see green)
   mode = 2: image correction for protanopia (unable to see red)
   mode = 3: image correction for tritanopia (unable to see blue)
   mode = 4: create simulation of how a person with deuteranopia perceives the uncorrected image
   mode = 5: create simulation of how a person with protanopia perceives the uncorrected image
   mode = 6: create simulation of how a person with tritanopia perceives the uncorrected image

   @copyright: 2008 by Oliver Siemoneit
   @license: GNU GPL, see COPYING for details.
"""

import os.path

try:
    from PIL import Image
except:
    raise Exception("Unable to import Python Imaging Library")

try:
    import PILdaltonize
except:
    raise Exception("Unable to import PILdaltonize extension module")

if __name__ == "__main__":
    import sys
   
    print "Daltonize image correction for color blind users"
    
    if len(sys.argv) != 3:
        print "Calling syntax: testPILdaltonize.py [fullpath to image file] [mode]"
        print "Example: testPILdaltonize.py C:/pic.png 1"
        sys.exit(1)

    fpath = sys.argv[1]

    if not (os.path.isfile(fpath)):
        print "Given file does not exist"
        sys.exit(1)

    extpos = fpath.rfind(".")
    if not (extpos > 0 and fpath[extpos:].lower() in ['.gif', '.jpg', '.jpeg', '.png', '.bmp', '.ico', ]):
        print "Given file is not an image"
        sys.exit(1)

    mode = int(sys.argv[2])

    path, fname = os.path.split(fpath)
    modified_fname = "%s-%s-%s" % ('daltonize', mode, fname)
    modified_fpath = os.path.join(path, modified_fname)

    if os.path.isfile(modified_fpath):
        print "Target file does already exist"
        sys.exit(1)

    im = Image.open(fpath)

    if im.mode in ['1', 'L']: 
        print "Given file is already a black/white or grayscale image"
        sys.exit(1)

    im = im.convert('RGB')
    im.load()

    imOut = Image.new(im.mode, im.size)

    import cProfile
    cProfile.run("PILdaltonize.daltonize(im.im.id, imOut.im.id, mode)")

##    result = PILdaltonize.daltonize(im.im.id, imOut.im.id, mode)
##    if result[0] != 0:
##        raise Exception, result[1]

    imOut.save(modified_fpath)

