# -*- coding: iso-8859-1 -*-
'''
main.py -- actual implementation of all macros in the package.
----
Copyright (C) 2007 Zoran Isailovski
Licensed under the Apache License, Version 2.0 (see http://www.apache.org/licenses/LICENSE-2.0)
or, at your option, under the terms described in the file LICENSE.txt found in the root of the 
distribution of this package (as far as it denotes a different license then the above).
----
'''

__todo__ = '''\
'''

DEBUG = True

# Graphviz executables - names (dot, neato, twopi, fdp) and location
GRAPHVIZ_TOOLS_DIR = 'tools'
GRAPHVIZ_TOOLS = 'dot twopi neato circo fdp'.split()
DEFAULT_TOOL = 'DOT' # keep this upper case to distinguish from explicit tool name

# Absolute location of the graphviz executables (dot, neato, twopi, fdp).
# Calculated from the above options - don't modify!
GRAPHVIZ = dict(
    [ (k, '%s/%s.exe' % (GRAPHVIZ_TOOLS_DIR, k))
      for k in GRAPHVIZ_TOOLS ])

######################################################################
## 
## Moin Interface
## 
######################################################################
import os
import re
from cStringIO import StringIO
from MoinMoin.parser import wiki
##from MoinMoin.Page import Page

#UID = 'BB962F5E-DB8E-424C-8E4D-D2B53286D6F3'

class Parser:
    """
    MoinMoin graphViz parser.
    """
    extensions = []
    Dependencies = []

    def __init__(self, raw, request, **kw):
        self.args = kw.get('format_args', 'dot')
        (tool, ) =  parseArguments(self.args)
        self.raw = raw
        self.request = request
        p = request.formatter.page
        self.renderer = Renderer(tool, targetdir=p.getPagePath('attachments'))

    def format(self, formatter):
        w = self.request.write
        ##w('<div style="border:3px ridge gray; padding:5px; width:95%; overflow:auto">')
        s = self.renderer.render(self.raw)
        s = wiki2html(self.request, 'attachment:%s' % os.path.basename(s))
        print '[TRACE] attachment URL:', s
        w(s)
        ##w('</div>')


def parseArguments(s):
    progs = '|'.join(GRAPHVIZ_TOOLS)
    pattern = r'^\s*(?P<tool>%s)?\s*$' % progs
    m = re.match(pattern, s, re.IGNORECASE)
    ##assert m, 'Invalid parser arguments'
    program = m and m.group('tool') or DEFAULT_TOOL
    return (program, )

def wiki2html(request, text):
    stream = StringIO()
    request.redirect(stream)
    parser =  wiki.Parser(text, request)
    parser.format(request.formatter)
    html = stream.getvalue()
    request.redirect()
    stream.close(); del stream
    return html


if __name__ == '__main__':
    print parseArguments('  fdp  ')
    print parseArguments('dot')
    print parseArguments('')
    print parseArguments('xxx')

######################################################################
## 
## Rendering Stuff
## 
######################################################################
import sys
import sha
import string

try: __file = __file__
except NameError: __file = sys.argv[0]

__filedir = os.path.join(os.path.dirname(__file))
__moindir = os.path.abspath(os.path.join(__filedir, '../../../../..'))
BASE_DIR = __moindir


class Snippets:
    '''
    Snippets are graph script fragments that can be included in the graph.
    To include snippet FOO, use $FOO in the graph.
    '''
    STD_GRAPH_HEADER = '''overlap=false
    node [fontname=Verdana fontsize=10 style=filled fillcolor=azure color=steelblue fontcolor=steelblue]
    edge [fontname=Verdana fontsize=8 color=steelblue fontcolor=steelblue]'''

    ATTEMPT_TO_JOIN_EDGES = 'concentrate=true'
    LEFT_TO_RIGHT = 'rankdir=LR'

SAMPLE_SCRIPT = r'''
digraph XXX {
    $STD_GRAPH_HEADER

    A -> {B C}; B -> C
}
'''

class Renderer:
    def __init__(self, tool='dot', targetdir='', format='png'):
        tool = GRAPHVIZ.get(tool) or GRAPHVIZ['dot']
        tool = os.path.join(BASE_DIR, tool)
        tool = os.path.normpath(tool)
        assert os.path.isfile(tool), 'File not found: %r' % tool
        self.toolpath = tool
        self.toolname = os.path.splitext(os.path.basename(tool))[0]
        self.targetdir = targetdir
        self.format = format

    def render(self, script):
        script = self.normalizedScript(script)
        uid = self.hashFor(script)
        gname = graphName(script) 
        imagefilename = 'graphviz-%s-%s.%s' % (gname, uid, self.format)
        imagefilename = os.path.join(self.targetdir, imagefilename)
        ##print '[TRACE] imagefilename:', imagefilename
        if not os.path.isfile(imagefilename):
            print '[TRACE] creating graph image:', imagefilename
            dotfilename = '%s-%s.%s' % ('graph', uid, 'graphviz.txt')
            dotfilename = os.path.join(self.targetdir, dotfilename)
            fwrite(dotfilename, script)
            try:
                renderGraphImage(self.toolpath, self.format, imagefilename, dotfilename)
            finally:
                os.remove(dotfilename)
        return imagefilename

    def normalizedScript(self, script=SAMPLE_SCRIPT):
        ##return script.strip() % vars(Snippets) # for syntax %(name)s
        ##return string.Template(script.strip()).safe_substitute(vars(Snippets)) # for syntax $name
        v =  vars(Snippets)
        return string.Template(script.strip() % v).safe_substitute(v) # for both syntaxes

    def hashFor(self, content):
        return sha.new(content).hexdigest()

def graphName(script):
    ##m = re.match(r'^(?:\n|\s)*(?:di)?graph\s*(\w*)', script) # allows spaces but no comments at beginning of script
    m = re.search(r'^(?:di)?graph\s*(\w*)', script, re.M)
    assert m, 'Could not derive graph name from graph script. Check the syntax, please!'
    return m.group(1)

def renderGraphImage(tool, format, imagefilename, dotfilename):
    cmd = '%(tool)s -T%(format)s -o"%(imagefilename)s" "%(dotfilename)s"' % locals()
    print '[TRACE] executing:', cmd
    os.system(cmd)

######################################################################
## 
## File IO Auxiliaries
## 
######################################################################

def fread(fname):
    f = open(fname, 'rt')
    try:
        return f.read()
    finally:
        f.close()

def fwrite(fname, content):
    f = open(fname, 'wt')
    try:
        return f.write(str(content))
    finally:
        f.close()

######################################################################
## 
## TEST
## 
######################################################################

TEST_SCRIPT = '''\
digraph X
{
    $STD_GRAPH_HEADER

    subgraph cluster1 {
        label="global space"
        node [fillcolor=cornsilk]
        P Q
    }
    B -> C
    C -> A
    Q -> A
}
'''

##if __name__ == '__main__':
##    print
##    r = Renderer('fdp')
##    s = r.render(TEST_SCRIPT)
##    print s
##    os.startfile(s)
