# -*- coding: utf-8 -*-
"""
    MoinMoin - rpc interface tests

    @copyright: 2007 by MoinMoin:JonasWagner
    @license: GNU GPL, see COPYING for details.
"""


import time
import xmlrpclib

import py

from MoinMoin import xmlrpc


class TestPutPage(object):
    """A unittest for the putpage method of the moin rpc interface"""

    def test_put_empty_page_content(self):
        interface = xmlrpc.XmlRpc2(self.request)
        assert isinstance(interface.xmlrpc_putPage("Test", ""),
                xmlrpclib.Fault)

    def test_put_empty_page_name(self):
        interface = xmlrpc.XmlRpc2(self.request)
        assert isinstance(interface.xmlrpc_putPage("", "Test"),
                xmlrpclib.Fault)

    def test_put_page(self):
        interface = xmlrpc.XmlRpc2(self.request)
        # time.time is used to make shure the content is changed every time
        assert not isinstance(interface.xmlrpc_putPage("Test",
            str(time.time())), xmlrpclib.Fault)

