# -*- coding: iso-8859-1 -*-
"""
    MoinMoin - subscribe to a page to get notified when it changes

    @copyright: 2000-2004 Juergen Hermann <jh@web.de>,
                2006 MoinMoin:ThomasWaldmann
    @license: GNU GPL, see COPYING for details.
"""
from MoinMoin.Page import Page

def execute(pagename, request):
    """ Subscribe the user to pagename """
    _ = request.getText
    cfg = request.cfg
    msg = None

    if not request.user.may.read(pagename):
        msg = _("You are not allowed to subscribe to a page you can't read.", formatted=False)

    # Check if mail is enabled
    elif not cfg.mail_enabled:
        msg = _("This wiki is not enabled for mail processing.", formatted=False)

    # Suggest visitors to login
    elif not request.user.valid:
        msg = _("You must log in to use subscriptions.", formatted=False)

    # Suggest users without email to add their email address
    elif not request.user.email:
        msg = _("Add your email address in your UserPreferences to use subscriptions.", formatted=True)

    elif request.user.isSubscribedTo([pagename]):
        msg = _('You are already subscribed to this page.', formatted=False)
    else:
        # Try to subscribe
        if request.user.subscribe(pagename):
            msg = _('You have been subscribed to this page.', formatted=False)
        else: # should not happen
            msg = _('You could not get subscribed to this page.', formatted=False)

    Page(request, pagename).send_page(msg=msg)

