# -*- coding: iso-8859-1 -*-
"""
    MoinMoin - AdvancedSearch Macro

    <<AdvancedSearch>>
        displays advanced search dialog.

    @license: GNU GPL, see COPYING for details.
"""

from MoinMoin.i18n import languages
from MoinMoin.support.python_compatibility import sorted
from MoinMoin.widget import html
from MoinMoin.util.web import makeSelection

import mimetypes

Dependencies = ['pages']


def form_get(request, name, default=''):
    """ Fetches a form field
    
    @param request: current request
    @param name: name of the field
    @keyword default: value if not present (default: '')
    """
    return request.form.get(name, [default])[0]


def advanced_ui(macro):
    """ Returns the code for the advanced search user interface

    @param macro: current macro instance
    """
    _ = macro._
    f = macro.formatter
    request = macro.request

    disabledIfMoinSearch = not request.cfg.xapian_search and \
            ' disabled="disabled"' or ''

    search_boxes = ''.join([
        f.table_row(1),
        f.table_cell(1, attrs={'rowspan': '6', 'class': 'searchfor'}),
        f.text(_('Search for items', formatted=False)),
        f.table_cell(0),
        ''.join([''.join([
            f.table_row(1),
            f.table_cell(1),
            f.text(txt),
            f.table_cell(0),
            f.table_cell(1),
            f.rawHTML(input_field),
            f.table_cell(0),
            f.table_row(0),
        ]) for txt, input_field in (
            (_('containing all the following terms', formatted=False),
                '<input type="text" name="and_terms" size="30" value="%s">'
                % (form_get(request, 'and_terms') or form_get(request, 'value'))),
            (_('containing one or more of the following terms', formatted=False),
                '<input type="text" name="or_terms" size="30" value="%s">'
                % form_get(request, 'or_terms')),
            (_('not containing the following terms', formatted=False),
                '<input type="text" name="not_terms" size="30" value="%s">'
                % form_get(request, 'not_terms')),
            #('containing only one of the following terms',
            #    '<input type="text" name="xor_terms" size="30" value="%s">'
            #    % form_get(request, 'xor_terms')),
            # TODO: dropdown-box?
            (_('belonging to one of the following categories', formatted=False),
                '<input type="text" name="categories" size="30" value="%s">'
                % form_get(request, 'categories')),
            (_('last modified since (e.g. last 2 weeks)', formatted=False),
                '<input type="text" name="mtime" size="30" value="%s">'
                % form_get(request, 'mtime')),
        )])
    ])

    # language selection
    searchedlang = form_get(request, 'language')
    langs = dict([(lang, lmeta['x-language-in-english'])
        for lang, lmeta in languages.items()])
    userlang = macro.request.lang
    lang_select = makeSelection('language',
            [('', _('any language', formatted=False)), (userlang, langs[userlang])] +
                sorted(langs.items(), key=lambda i: i[1]),
            searchedlang)

    # mimetype selection
    mimetype = form_get(request, 'mimetype')
    mt_select = makeSelection('mimetype',
            [('', _('any mimetype', formatted=False))] + [(m[1], '*%s - %s' % m) for m in sorted(mimetypes.types_map.items())],
            mimetype)


    # misc search options (checkboxes)
    search_options = ''.join([
        ''.join([
            f.table_row(1),
            f.table_cell(1, attrs={'class': 'searchfor'}),
            txt[0],
            f.table_cell(0),
            f.table_cell(1, colspan=2),
            unicode(txt[1]),
            txt[2],
            f.table_cell(0),
            f.table_row(0),
            ]) for txt in (
                (_('Language', formatted=False), unicode(lang_select), ''),
                (_('File Type', formatted=False), unicode(mt_select), ''),
                ('', html.INPUT(type='checkbox', name='titlesearch',
                    value='1', checked=form_get(request, 'titlesearch'),
                    id='titlesearch'),
                    '<label for="titlesearch">%s</label>' % _('Search only in titles', formatted=False)),
                ('', html.INPUT(type='checkbox', name='case', value='1',
                    checked=form_get(request, 'case'), id='case'),
                    '<label for="case">%s</label>' % _('Case-sensitive search', formatted=False)),
                ('', html.INPUT(type='checkbox', name='excludeunderlay',
                    value='1', checked=form_get(request, 'excludeunderlay'),
                    id='excludeunderlay'),
                    '<label for="excludeunderlay">%s</label>' % _('Exclude underlay', formatted=False)),
                ('', html.INPUT(type='checkbox', name='nosystemitems',
                    value='1', checked=form_get(request, 'nosystemitems'),
                    id='nosystempages'),
                    '<label for="nosystempages">%s</label>' % _('No system items', formatted=False)),
                ('', html.INPUT(type='checkbox', name='historysearch',
                    value='1', checked=form_get(request, 'historysearch'),
                    disabled=(not request.cfg.xapian_search or
                        not request.cfg.xapian_index_history),
                    id='historysearch'),
                    '<label for="historysearch">%s</label>' % _('Search in all page revisions', formatted=False))
            )
    ])

    # the dialogue
    return f.rawHTML('\n'.join([
        u'<form method="get" action="">',
        u'<div>',
        u'<input type="hidden" name="action" value="fullsearch">',
        u'<input type="hidden" name="advancedsearch" value="1">',
        f.table(1, attrs={'tableclass': 'advancedsearch'}),
        search_boxes,
        search_options,
        f.table_row(1),
        f.table_cell(1, attrs={'class': 'submit', 'colspan': '3'}),
        u'<input type="submit" value="%s">' % _('Go get it!', formatted=False),
        f.table_cell(0),
        f.table_row(0),
        f.table(0),
        u'</div>',
        u'</form>',
    ]))


def execute(macro, needle):
    # for now, just show the advanced ui
    return advanced_ui(macro)

