# Add to moin config

# Security policy
# Tested only with moin 1.1
try:
    import cPickle as pickle
except ImportError:
    import pickle
from blacklist import blacklist
from MoinMoin import security


class SecurityPolicy(security.Default):
    def __init__(self, user):
        security.Default.__init__(self, user)
        self.loadBlacklist()
                 
    def edit(self, pagename, **kw):
        """ Extend the default edit permissions """

        # blacklist only non users
        if not self.user.valid and hasattr(self, 'blacklist'):
            # Needed for moin 1.1 compatibility
            if not hasattr(self.user._request, 'remote_addr'):
                import os
                self.user._request.remote_addr = os.environ.get('REMOTE_ADDR', '')
            # Blacklist
            if self.user._request.remote_addr in self.blacklist:
                return 0
        
        # Use standard permissions
        return security.Default.edit(self, pagename, **kw)
        
    def loadBlacklist(self):
        """ Load data from file or wiki page """
        import sys
        blacklistFile = 'blacklist.cache'
        try:
            self.blacklist = pickle.load(file(blacklistFile))
        except (IOError, OSError, pickle.UnpicklingError), why:
            # Read the data from a text file, or better from 
            # a wiki page.
            sys.stderr.write('load blacklist failed %s:' % str(why))
            text = file('blacklist.txt').read()
            self.blacklist = blacklist.BlackList(text)
            try:
                pickle.dump(self.blacklist, file(blacklistFile, 'w'))
            except (IOError, pickle.PicklingError), why:
                sys.stderr.write('cache blacklist failed: %s' % str(why))
