# -*- coding: UTF8 -*-
"""
    MoinMoin - ... action

    Allows to ... .

    @copyright: 20??-20?? Autho Name <author@url.org>,
    @license: GNU GPL, see COPYING for details.
"""

from MoinMoin import wikiutil
from MoinMoin.Page import Page
from MoinMoin.parser.text_moin_wiki import Parser as MoinParser


class Action():
    def __init__(self, pagename, request):
        self.request = request
        self.pagename = self.request.page.page_name
        self.formatter = self.request.formatter
        self.page = Page(self.request, self.pagename)
        self.formatter.page = self.page
        self.pagepath = self.page.getPageBasePath()[1]
        self.url = self.request.href(self.request.page.page_name)
        self.url_full = self.request.getQualifiedURL(self.url)
        self.title = self.page.split_title()
        self.formargs = self.request.values
        self.get_all_my_page_text = wikiutil.importPlugin(self.request.cfg, 'parser', 'template', 'get_all_my_page_text')
        self.settings = wikiutil.importPlugin(self.request.cfg, 'parser', 'template', 'settings')
        self.error = u''
        self.no_error = self.error

        try:
            needle = u''
            for key in self.formargs:
                if key != 'action':
                    needle += key + '=' + self.formargs[key] + ','
            needle = needle[:-1]
            #TODO: FINDE EINEN ERSATZ (FORMARGS) für '' IN DER NÄCHSTEN ZEILE
            my_settings = wikiutil.invoke_extension_function(self.request, self.settings, needle)
            for key, value in my_settings.items():
                setattr(self, key, value)
            # saves the state of valid input
        except ValueError, err:
            self.error += "/!\\ " + str(err) + " /!\\\n"
        else:
            if self.subpage_of == self.settings()['subpage_of']:
                self.subpage_of = None
            # your functionality from here on

    def message(self, txt):
        self.request.theme.add_msg(self.request.getText(txt))
        return self.page.send_page()

    def do(self):
        #
        if self.formargs.get('message') != None:
            return self.message(u"Send a message.\n")
        else:
            self.request.setContentLanguage(self.request.lang)
            self.request.theme.send_title(self.request.getText(u'Action-Template on Page "%s"') % (self.title, ), page=self.page)
            moin_output = """
== Page Information ==
 * Moin-Pagename: %s
 * Moin-Pagetitle: %s
 * Moin-Pagepath: %s
 * Page-Url: %s
 * Full Page-Url: %s

== Url/ Form data ==
""" % (self.pagename, self.title, self.pagepath, self.url, self.url_full)
            for key in self.formargs.keys():
                moin_output += u" * %s=%s\n" % (key, self.formargs.get(key))
            moin_output += "== Acl ==\n"
            if self.request.user.may.read(self.pagename):
                moin_output += u" * You have read rights.\n"
            else:
                moin_output += " * You don't have read rights.\n"
            if self.request.user.may.write(self.pagename):
                moin_output += u" * You have write rights.\n"
            else:
                moin_output += u" * You don't have write rights.\n"
            moin_output += "== Settings ==\n"
            for key in self.settings().keys():
                try:
                    moin_output += u" * %s=%s\n" % (key, str(getattr(self, key)))
                except:
                    moin_output += u" * %s= /!\\ Not existing /!\\\n" % (key)
            tc = self.get_all_my_page_text(self.request, self.subpage_of)
            for page_name in tc:
                moin_output += "=== %s ===\n" % page_name
                for wiki_text in tc[page_name]:
                    moin_output += u"{{{\n%s\n}}}\n" % (wiki_text)
            parser = MoinParser(moin_output, self.request)
            parser.format(self.formatter)
            self.request.theme.send_footer(self.pagename)
            self.request.theme.send_closing_html()
            return ''


def execute(pagename, request):
    return Action(pagename, request).do()
