# -*- coding: UTF8 -*-
"""
    MoinMoin - ... action

    Allows to ... .

    @copyright: 20??-20?? Autho Name <author@url.org>,
    @license: GNU GPL, see COPYING for details.
"""

import os
import re
from inspect import getargspec

from MoinMoin import search
from MoinMoin import wikiutil
from MoinMoin.Page import Page
from MoinMoin.parser.text_moin_wiki import Parser as MoinParser

plugin_name = os.path.splitext(os.path.basename(__file__))[0]


def get_all_my_page_text(request, subpage_of=None):
    """ Returns a dict of pages with content for this parser.
        @param request: MoinMoin request object.
        @param subpage_of: reduces the pages to subpages_of or all if subpages_of is None
        @return: dictionary with page_names and a list of the content for this parser
    """
    def add_text(text_collector, page_name, text):
        if not page_name in text_collector:
            text_collector[page_name] = list()
        text_collector[page_name].append(text)

    tc = dict()
    query = search.QueryParser().parse_query('"#format %(pn)s" or "{{{#!%(pn)s"' % {'pn': plugin_name})
    regen = re.compile(r'{{{#!%s(.+?)}}}' % plugin_name, re.DOTALL)
    results = search.searchPages(request, query)

    for SearchPage in results.hits:
        page = Page(request, SearchPage.page_name)
        # parse schedule(s) only if user has read access
        if request.user.may.read(page.page_name):
            if subpage_of == None or page.page_name.startswith(subpage_of):
                page_text = page.getPageText()
                if page.parse_processing_instructions()['format'] == plugin_name:
                    add_text(tc, page.page_name, page_text)
                elif page_text.find("{{{#!%s" % plugin_name) >= 0:
                    for text in regen.findall(page_text):
                        text = text[text.find('\n') + 1:]   # delete rest of the first line (parameter section of parser)
                        add_text(tc, page.page_name, text)
    return tc


def settings(subpage_of=u'None', par=0):
    """ dummy function to initialize all default parameters for the plugin. The parameters are checked for wrong input.
        @param subpage_of: reduces the searched pages to subpages_of or all if subpages_of is None
        @param par: Dummy parameter
    """
    return locals()


def update_defaults_by_wikiconfig(cfg, plugin_name, settings_function):
    """ function to overwrite defaults of settings_function by wikiconfig attributes
    @param cfg: wiki config instance
    @param plugin_name: this is the namespace prefix for parameters of the plugin (plugin_name_param has to be defined in wikiconfig).
    @param settings_function: function whose defaults have to be updated by wikiconfig
    """
    def get_arg_default(cfg, plugin_name, name, settings_function):
        try:
            return getattr(cfg, "%s_%s" % (plugin_name, name))
        except AttributeError:
            return getargspec(settings_function)[3][getargspec(settings_function)[0].index(name)]
    settings_function.func_defaults = tuple([get_arg_default(cfg, plugin_name, arg, settings_function)
                                             for arg in getargspec(settings_function)[0]])


class Parser:
    """
        Description
    """
    def __init__(self, wikitext, request, **kw):
        self.wikitext = wikitext
        self.request = request
        self.pagename = self.request.page.page_name
        self.formatter = self.request.formatter
        self.page = Page(self.request, self.pagename)
        self.pagepath = self.page.getPageBasePath()[1]
        self.url = self.request.href(self.request.page.page_name)
        self.url_full = self.request.getQualifiedURL(self.url)
        self.title = self.page.split_title()
        self.formargs = self.request.values
        update_defaults_by_wikiconfig(request.cfg, plugin_name, settings)
        # we use a macro definition to initialize the default init parameters
        # if a user enters a wrong parameter the failure is shown by the exception
        self.error = u''
        self.no_error = self.error

        try:
            my_settings = wikiutil.invoke_extension_function(request, settings, kw.get('format_args', ''))
            for key, value in my_settings.items():
                setattr(self, key, value)
            # saves the state of valid input
        except ValueError, err:
            self.error += "/!\\ " + str(err) + " /!\\\n"
        else:
            if self.subpage_of == settings()['subpage_of']:
                self.subpage_of = None
            # your functionality from here on

    def format(self, formatter):
        """
            Send the "parsed" text.
        """
        if self.error == self.no_error:
            moin_output = """
== Page Information ==
 * Moin-Pagename: %s
 * Moin-Pagetitle: %s
 * Moin-Pagepath: %s
 * Page-Url: %s
 * Full Page-Url: %s

== Url/ Form data ==
""" % (self.pagename, self.title, self.pagepath, self.url, self.url_full)
            for key in self.formargs.keys():
                moin_output += u" * %s=%s\n" % (key, self.formargs.get(key))
            moin_output += "== Acl ==\n"
            if self.request.user.may.read(self.pagename):
                moin_output += u" * You have read rights.\n"
            else:
                moin_output += " * You don't have read rights.\n"
            if self.request.user.may.write(self.pagename):
                moin_output += u" * You have write rights.\n"
            else:
                moin_output += u" * You don't have write rights.\n"
            moin_output += "== Text to parse ==\n"
            moin_output += u"{{{\n%s\n}}}\n" % (self.wikitext)
            moin_output += "== Settings ==\n"
            for key in settings().keys():
                try:
                    moin_output += u" * %s=%s\n" % (key, str(getattr(self, key)))
                except:
                    moin_output += u" * %s= /!\\ Not existing /!\\\n" % (key)
            moin_output += "== Wiki Content for this parser ==\n"
            tc = get_all_my_page_text(self.request, self.subpage_of)
            for page_name in tc:
                moin_output += "=== %s ===\n" % page_name
                for wiki_text in tc[page_name]:
                    moin_output += u"{{{\n%s\n}}}\n" % (wiki_text)
        else:
            moin_output = self.error
        parser = MoinParser(moin_output, self.request)
        parser.format(self.formatter)
