/*
 MoinMoin Java Editor Applet
 Copyright (c) 2003 Nick Trout.
 */

package moineditorapplet;

import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import javax.swing.*;
import javax.swing.border.*;

public class MoinEditorApplet extends Applet {
  String textContents;
  private boolean isStandalone = false;
  MoinPageEditor pageeditor;

  // GUI
  JToolBar jToolBar1 = new JToolBar();
  JScrollPane jScrollPaneEdit = new JScrollPane();
  BorderLayout borderLayout1 = new BorderLayout();
  JTextArea jTextAreaEdit = new JTextArea();
  JPanel jPanelToolbar = new JPanel();
  JButton jButtonSection1 = new JButton();
  GridLayout gridLayoutSections = new GridLayout();
  JPanel jPanelSection = new JPanel();
  JButton jButtonSection2 = new JButton();
  JButton jButtonSection4 = new JButton();
  JButton jButtonSection3 = new JButton();
  JPanel jPanelStyle = new JPanel();
  JButton jButtonItalics = new JButton();
  GridLayout gridLayoutStyles = new GridLayout();
  JButton jButtonBold = new JButton();
  FlowLayout flowLayoutAll = new FlowLayout();
  JPanel jPanelLists = new JPanel();
  JButton jButtonListBullet = new JButton();
  GridLayout gridLayoutLists = new GridLayout();
  JButton jButtonListAbc = new JButton();
  JButton jButtonListRoman = new JButton();

  //Get a parameter value
  public String getParameter(String key, String def) {
    return isStandalone ? System.getProperty(key, def) :
      (getParameter(key) != null ? getParameter(key) : def);
  }

  //Construct the applet
  public MoinEditorApplet() {
  }
  //Initialize the applet
  public void init() {
    try {
      textContents = this.getParameter("contents", "");
    }
    catch(Exception e) {
      e.printStackTrace();
    }
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
    pageeditor = new MoinPageEditor(jTextAreaEdit);
    pageeditor.setPageContent(textContents);
    jButtonBold.addActionListener(pageeditor);
    jButtonItalics.addActionListener(pageeditor);
    jButtonSection1.addActionListener(pageeditor);
    jButtonSection2.addActionListener(pageeditor);
    jButtonSection3.addActionListener(pageeditor);
    jButtonSection4.addActionListener(pageeditor);
    jButtonListBullet.addActionListener(pageeditor);
    jButtonListAbc.addActionListener(pageeditor);
    jButtonListRoman.addActionListener(pageeditor);
  }
  //Component initialization
  private void jbInit() throws Exception {
    jButtonSection1.setText("=_=");
    jButtonSection1.setFont(new java.awt.Font("SansSerif", 0, 9));
    jButtonSection1.setPreferredSize(new Dimension(49, 21));
    jButtonSection1.setActionCommand("section1");
    gridLayoutSections.setColumns(2);
    gridLayoutSections.setHgap(0);
    gridLayoutSections.setRows(2);
    gridLayoutSections.setVgap(0);
    jPanelSection.setBorder(BorderFactory.createEtchedBorder());
    jPanelSection.setMinimumSize(new Dimension(160, 46));
    jPanelSection.setLayout(gridLayoutSections);
    jButtonSection2.setText("==_==");
    jButtonSection2.setFont(new java.awt.Font("SansSerif", 0, 9));
    jButtonSection2.setActionCommand("section2");
    jButtonSection4.setText("====_====");
    jButtonSection4.setFont(new java.awt.Font("SansSerif", 0, 9));
    jButtonSection4.setActionCommand("section4");
    jButtonSection4.setMargin(new Insets(2, 2, 2, 2));
    jButtonSection3.setText("===_===");
    jButtonSection3.setFont(new java.awt.Font("SansSerif", 0, 9));
    jButtonSection3.setActionCommand("section3");
    jButtonSection3.setMargin(new Insets(2, 2, 2, 2));
    jButtonItalics.setActionCommand("styleItalic");
    jButtonItalics.setMargin(new Insets(2, 2, 2, 2));
    jButtonItalics.setFont(new java.awt.Font("Serif", 3, 20));
    jButtonItalics.setForeground(Color.black);
    jButtonItalics.setOpaque(true);
    jButtonItalics.setPreferredSize(new Dimension(32, 32));
    jButtonItalics.setText("I");
    jPanelToolbar.setLayout(flowLayoutAll);
    jPanelStyle.setLayout(gridLayoutStyles);
    jButtonBold.setFont(new java.awt.Font("SansSerif", 1, 20));
    jButtonBold.setMinimumSize(new Dimension(49, 35));
    jButtonBold.setPreferredSize(new Dimension(32, 32));
    jButtonBold.setActionCommand("styleBold");
    jButtonBold.setMargin(new Insets(2, 2, 2, 2));
    jButtonBold.setText("B");
    jTextAreaEdit.setLineWrap(true);
    jTextAreaEdit.setWrapStyleWord(true);
    jButtonListBullet.setActionCommand("listBullet");
    jButtonListBullet.setMargin(new Insets(2, 2, 2, 2));
    jButtonListBullet.setText("* * *");
    jPanelLists.setLayout(gridLayoutLists);
    jButtonListAbc.setActionCommand("listAbc");
    jButtonListAbc.setMargin(new Insets(2, 2, 2, 2));
    jButtonListAbc.setText("a. b. c.");
    jButtonListRoman.setFont(new java.awt.Font("Dialog", 0, 12));
    jButtonListRoman.setActionCommand("listRoman");
    jButtonListRoman.setMargin(new Insets(2, 2, 2, 2));
    jButtonListRoman.setText("i. ii. iii.");
    gridLayoutLists.setColumns(2);
    gridLayoutLists.setRows(2);
    jPanelLists.setBorder(BorderFactory.createEtchedBorder());
    jPanelStyle.add(jButtonBold, null);
    jPanelStyle.add(jButtonItalics, null);
    jPanelSection.add(jButtonSection1, null);
    jPanelSection.add(jButtonSection2, null);
    jPanelSection.add(jButtonSection3, null);
    jPanelSection.add(jButtonSection4, null);
    jPanelToolbar.add(jPanelStyle, null);
    jPanelToolbar.add(jPanelLists, null);
    jScrollPaneEdit.setDebugGraphicsOptions(0);
    this.setLayout(borderLayout1);
    jTextAreaEdit.setText("Moin");
    this.add(jScrollPaneEdit, BorderLayout.CENTER);
    this.add(jToolBar1, BorderLayout.SOUTH);
    this.add(jPanelToolbar, BorderLayout.NORTH);
    jScrollPaneEdit.getViewport().add(jTextAreaEdit, null);
    jPanelLists.add(jButtonListBullet, null);
    jPanelLists.add(jButtonListAbc, null);
    jPanelLists.add(jButtonListRoman, null);
    jPanelToolbar.add(jPanelSection, null);
  }
  //Start the applet
  public void start() {
  }
  //Stop the applet
  public void stop() {
  }
  //Destroy the applet
  public void destroy() {
  }
  //Get Applet information
  public String getAppletInfo() {
    return "Applet Information";
  }
  //Get parameter info
  public String[][] getParameterInfo() {
    String[][] pinfo =
      {
      {"contents", "String", "Wiki format text to edit"},
      };
    return pinfo;
  }
  //Main method
  public static void main(String[] args) {
    MoinEditorApplet applet = new MoinEditorApplet();
    applet.isStandalone = true;
    Frame frame;
    frame = new Frame();
    frame.setTitle("Applet Frame");
    frame.add(applet, BorderLayout.CENTER);
    applet.init();
    applet.start();
    frame.setSize(800,620);
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    frame.setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
    frame.setVisible(true);
  }
}

