/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.FontSizeHandle;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.standard.LocatorHandle;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.OffsetLocator;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.standard.TextHolder;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;

public class TextFigure
extends AttributeFigure
implements FigureChangeListener,
TextHolder {
    private int fOriginX = 0;
    private int fOriginY = 0;
    private transient boolean fSizeIsDirty = true;
    private transient int fWidth;
    private transient int fHeight;
    private String fText;
    private Font fFont = TextFigure.createCurrentFont();
    private boolean fIsReadOnly;
    private Figure fObservedFigure = null;
    private OffsetLocator fLocator = null;
    private static String fgCurrentFontName = "Helvetica";
    private static int fgCurrentFontSize = 12;
    private static int fgCurrentFontStyle = 0;
    private static final long serialVersionUID = 4599820785949456124L;
    private int textFigureSerializedDataVersion = 1;

    public TextFigure() {
        this.setAttribute("FillColor", ColorMap.getColorMap().color("None"));
        this.fText = new String("");
        this.fSizeIsDirty = true;
    }

    public void moveBy(int n, int n2) {
        this.willChange();
        this.basicMoveBy(n, n2);
        if (this.fLocator != null) {
            this.fLocator.moveBy(n, n2);
        }
        this.changed();
    }

    protected void basicMoveBy(int n, int n2) {
        this.fOriginX += n;
        this.fOriginY += n2;
    }

    public void basicDisplayBox(Point point, Point point2) {
        this.fOriginX = point.x;
        this.fOriginY = point.y;
    }

    public Rectangle displayBox() {
        Dimension dimension = this.textExtent();
        return new Rectangle(this.fOriginX, this.fOriginY, dimension.width, dimension.height);
    }

    public Rectangle textDisplayBox() {
        return this.displayBox();
    }

    public boolean readOnly() {
        return this.fIsReadOnly;
    }

    public void setReadOnly(boolean bl) {
        this.fIsReadOnly = bl;
    }

    public Font getFont() {
        return this.fFont;
    }

    public void setFont(Font font) {
        this.willChange();
        this.fFont = font;
        this.markDirty();
        this.changed();
    }

    public void changed() {
        super.changed();
        this.updateLocation();
    }

    public Object getAttribute(String string) {
        Font font = this.getFont();
        if (string.equals("FontSize")) {
            return new Integer(font.getSize());
        }
        if (string.equals("FontStyle")) {
            return new Integer(font.getStyle());
        }
        if (string.equals("FontName")) {
            return font.getName();
        }
        return super.getAttribute(string);
    }

    public void setAttribute(String string, Object object) {
        Font font = this.getFont();
        if (string.equals("FontSize")) {
            Integer n = (Integer)object;
            this.setFont(new Font(font.getName(), font.getStyle(), n));
        } else if (string.equals("FontStyle")) {
            Integer n = (Integer)object;
            int n2 = font.getStyle();
            n2 = n == 0 ? 0 : (n2 ^= n.intValue());
            this.setFont(new Font(font.getName(), n2, font.getSize()));
        } else if (string.equals("FontName")) {
            String string2 = (String)object;
            this.setFont(new Font(string2, font.getStyle(), font.getSize()));
        } else {
            super.setAttribute(string, object);
        }
    }

    public String getText() {
        return this.fText;
    }

    public void setText(String string) {
        if (!string.equals(this.fText)) {
            this.willChange();
            this.fText = new String(string);
            this.markDirty();
            this.changed();
        }
    }

    public boolean acceptsTyping() {
        return !this.fIsReadOnly;
    }

    public void drawBackground(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawFrame(Graphics graphics) {
        graphics.setFont(this.fFont);
        graphics.setColor((Color)this.getAttribute("TextColor"));
        FontMetrics fontMetrics = graphics.getFontMetrics(this.fFont);
        Dimension dimension = this.textExtent();
        int n = this.fOriginY;
        LineIterator lineIterator = new LineIterator(this.fText);
        while (lineIterator.hasMoreLines()) {
            String string = lineIterator.nextLine();
            int n2 = this.fOriginX;
            String string2 = (String)this.getAttribute("TextAlign");
            if (string2.equals("Right")) {
                n2 += dimension.width - fontMetrics.stringWidth(string);
            } else if (string2.equals("Centre")) {
                n2 += (dimension.width - fontMetrics.stringWidth(string)) / 2;
            }
            graphics.drawString(string, n2, n + fontMetrics.getAscent());
            n += fontMetrics.getHeight();
        }
    }

    private Dimension textExtent() {
        if (!this.fSizeIsDirty) {
            return new Dimension(this.fWidth, this.fHeight);
        }
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.fFont);
        this.fWidth = 0;
        this.fHeight = 0;
        LineIterator lineIterator = new LineIterator(this.fText);
        while (lineIterator.hasMoreLines()) {
            String string = lineIterator.nextLine();
            this.fHeight += fontMetrics.getHeight();
            int n = fontMetrics.stringWidth(string);
            if (n <= this.fWidth) continue;
            this.fWidth = n;
        }
        this.fSizeIsDirty = false;
        return new Dimension(this.fWidth, this.fHeight);
    }

    private void markDirty() {
        this.fSizeIsDirty = true;
    }

    private Dimension getRowsAndColumns(String string) {
        int n = 0;
        int n2 = 0;
        LineIterator lineIterator = new LineIterator(string);
        while (lineIterator.hasMoreLines()) {
            String string2 = lineIterator.nextLine();
            if (string2.length() > n2) {
                n2 = string2.length();
            }
            ++n;
        }
        return new Dimension(n2, n);
    }

    public int overlayColumns() {
        Dimension dimension = this.getRowsAndColumns(this.getText());
        return dimension.width < 20 ? 20 : dimension.width;
    }

    public int overlayRows() {
        Dimension dimension = this.getRowsAndColumns(this.getText());
        return dimension.height < 5 ? 5 : dimension.height;
    }

    public Vector handles() {
        Vector<LocatorHandle> vector = new Vector<LocatorHandle>();
        vector.addElement(new NullHandle(this, RelativeLocator.northWest()));
        vector.addElement(new NullHandle(this, RelativeLocator.northEast()));
        vector.addElement(new NullHandle(this, RelativeLocator.southEast()));
        vector.addElement(new FontSizeHandle(this, RelativeLocator.southWest()));
        return vector;
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.fOriginX);
        storableOutput.writeInt(this.fOriginY);
        storableOutput.writeString(this.fText);
        storableOutput.writeString(this.fFont.getName());
        storableOutput.writeInt(this.fFont.getStyle());
        storableOutput.writeInt(this.fFont.getSize());
        storableOutput.writeBoolean(this.fIsReadOnly);
        storableOutput.writeStorable(this.fObservedFigure);
        storableOutput.writeStorable(this.fLocator);
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.markDirty();
        this.fOriginX = storableInput.readInt();
        this.fOriginY = storableInput.readInt();
        this.fText = storableInput.readString();
        this.fFont = new Font(storableInput.readString(), storableInput.readInt(), storableInput.readInt());
        this.fIsReadOnly = storableInput.readBoolean();
        this.fObservedFigure = (Figure)storableInput.readStorable();
        if (this.fObservedFigure != null) {
            this.setAttribute("observed.figure", this.fObservedFigure);
            this.fObservedFigure.addFigureChangeListener(this);
        }
        this.fLocator = (OffsetLocator)storableInput.readStorable();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.fObservedFigure != null) {
            this.fObservedFigure.addFigureChangeListener(this);
        }
        this.markDirty();
    }

    public void connect(Figure figure) {
        if (this.fObservedFigure != null) {
            this.fObservedFigure.removeFigureChangeListener(this);
        }
        this.fObservedFigure = figure;
        this.fLocator = new OffsetLocator(figure.connectedTextLocator(this));
        this.fObservedFigure.addFigureChangeListener(this);
        this.setAttribute("observed.figure", this.fObservedFigure);
        this.updateLocation();
    }

    public void figureChanged(FigureChangeEvent figureChangeEvent) {
        this.updateLocation();
    }

    public void figureRemoved(FigureChangeEvent figureChangeEvent) {
        if (this.listener() != null) {
            this.listener().figureRequestRemove(new FigureChangeEvent(this));
        }
    }

    public void figureRequestRemove(FigureChangeEvent figureChangeEvent) {
    }

    public void figureInvalidated(FigureChangeEvent figureChangeEvent) {
    }

    public void figureRequestUpdate(FigureChangeEvent figureChangeEvent) {
    }

    protected void updateLocation() {
        if (this.fLocator != null) {
            Point point = this.fLocator.locate(this.fObservedFigure);
            point.x -= this.size().width / 2 + this.fOriginX;
            point.y -= this.size().height / 2 + this.fOriginY;
            if (point.x != 0 || point.y != 0) {
                this.willChange();
                this.basicMoveBy(point.x, point.y);
                this.changed();
            }
        }
    }

    public void release() {
        super.release();
        if (this.fObservedFigure != null) {
            this.fObservedFigure.removeFigureChangeListener(this);
        }
    }

    public void disconnect() {
        this.fObservedFigure.removeFigureChangeListener(this);
        this.fObservedFigure = null;
        this.fLocator = null;
        this.setAttribute("observed.figure", null);
    }

    public static Font createCurrentFont() {
        return new Font(fgCurrentFontName, fgCurrentFontStyle, fgCurrentFontSize);
    }

    public static void setCurrentFontName(String string) {
        fgCurrentFontName = string;
    }

    public static void setCurrentFontSize(int n) {
        fgCurrentFontSize = n;
    }

    public static void setCurrentFontStyle(int n) {
        fgCurrentFontStyle = n;
    }

    private class LineIterator {
        int place;
        String s;

        public LineIterator(String string) {
            this.s = string;
            this.place = 0;
        }

        public boolean hasMoreLines() {
            return this.place < this.s.length();
        }

        public String nextLine() {
            int n = this.s.indexOf("\n", this.place);
            if (n < 0) {
                n = this.s.length();
            }
            String string = this.s.substring(this.place, n);
            this.place = n + 1;
            return string;
        }
    }
}

