/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.HJDError;
import CH.ifa.draw.standard.AbstractTool;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class CreationTool
extends AbstractTool {
    private Point fAnchorPoint;
    private Figure fCreatedFigure;
    private Figure fPrototype;

    public CreationTool(DrawingView drawingView, Figure figure) {
        super(drawingView);
        this.fPrototype = figure;
    }

    protected CreationTool(DrawingView drawingView) {
        super(drawingView);
        this.fPrototype = null;
    }

    public void activate() {
        this.view().setCursor(Cursor.getPredefinedCursor(1));
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        this.fAnchorPoint = new Point(n, n2);
        this.fCreatedFigure = this.createFigure();
        this.fCreatedFigure.displayBox(this.fAnchorPoint, this.fAnchorPoint);
        this.view().add(this.fCreatedFigure);
    }

    protected Figure createFigure() {
        if (this.fPrototype == null) {
            throw new HJDError("No prototype defined");
        }
        return (Figure)this.fPrototype.clone();
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        this.fCreatedFigure.displayBox(this.fAnchorPoint, new Point(n, n2));
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        if (this.fCreatedFigure.isEmpty()) {
            this.drawing().remove(this.fCreatedFigure);
        }
        this.fCreatedFigure = null;
        this.editor().toolDone();
    }

    protected Figure createdFigure() {
        return this.fCreatedFigure;
    }
}

