/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.util.Storable;
import java.awt.Color;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;

public class StorableOutput {
    private PrintWriter fStream;
    private Vector fMap;
    private int fIndent;

    public StorableOutput(OutputStream outputStream) {
        this.fStream = new PrintWriter(outputStream);
        this.fMap = new Vector();
        this.fIndent = 0;
    }

    public void writeStorable(Storable storable) {
        if (storable == null) {
            this.fStream.print("NULL");
            this.space();
            return;
        }
        if (this.mapped(storable)) {
            this.writeRef(storable);
            return;
        }
        this.incrementIndent();
        this.startNewLine();
        this.map(storable);
        this.fStream.print(storable.getClass().getName());
        this.space();
        storable.write(this);
        this.space();
        this.decrementIndent();
    }

    public void writeInt(int n) {
        this.fStream.print(n);
        this.space();
    }

    public void writeColor(Color color) {
        this.writeInt(color.getRed());
        this.writeInt(color.getGreen());
        this.writeInt(color.getBlue());
    }

    public void writeDouble(double d) {
        this.fStream.print(d);
        this.space();
    }

    public void writeBoolean(boolean bl) {
        if (bl) {
            this.fStream.print(1);
        } else {
            this.fStream.print(0);
        }
        this.space();
    }

    public void writeString(String string) {
        this.fStream.print('\"');
        block12: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\r': {
                    this.fStream.print('\\');
                    this.fStream.print('r');
                    continue block12;
                }
                case '\n': {
                    this.fStream.print('\\');
                    this.fStream.print('n');
                    continue block12;
                }
                case '\"': {
                    this.fStream.print('\\');
                    this.fStream.print('\"');
                    continue block12;
                }
                case '\\': {
                    this.fStream.print('\\');
                    this.fStream.print('\\');
                    continue block12;
                }
                case '\t': {
                    this.fStream.print('\\');
                    this.fStream.print('t');
                    continue block12;
                }
                default: {
                    if (c >= '\u0001' && c <= '\u007f') {
                        this.fStream.print(c);
                        continue block12;
                    }
                    String string2 = Integer.toHexString(c);
                    switch (string2.length()) {
                        case 1: {
                            this.fStream.print("\\\\u000" + string2);
                            continue block12;
                        }
                        case 2: {
                            this.fStream.print("\\\\u00" + string2);
                            continue block12;
                        }
                        case 3: {
                            this.fStream.print("\\\\u0" + string2);
                            continue block12;
                        }
                    }
                    this.fStream.print("\\\\u" + string2);
                }
            }
        }
        this.fStream.print('\"');
        this.space();
    }

    public void close() {
        this.fStream.close();
    }

    private boolean mapped(Storable storable) {
        return this.fMap.contains(storable);
    }

    private void map(Storable storable) {
        if (!this.fMap.contains(storable)) {
            this.fMap.addElement(storable);
        }
    }

    private void writeRef(Storable storable) {
        int n = this.fMap.indexOf(storable);
        this.fStream.print("REF");
        this.space();
        this.fStream.print(n);
        this.space();
    }

    private void incrementIndent() {
        this.fIndent += 4;
    }

    private void decrementIndent() {
        this.fIndent -= 4;
        if (this.fIndent < 0) {
            this.fIndent = 0;
        }
    }

    private void startNewLine() {
        this.fStream.println();
        for (int i = 0; i < this.fIndent; ++i) {
            this.space();
        }
    }

    private void space() {
        this.fStream.print(' ');
    }
}

