/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller;

import freemind.controller.ColorSwatch;
import freemind.controller.LastOpenedList;
import freemind.controller.MainToolBar;
import freemind.controller.MapMouseMotionListener;
import freemind.controller.MapMouseWheelListener;
import freemind.controller.NodeDragListener;
import freemind.controller.NodeDropListener;
import freemind.controller.NodeKeyListener;
import freemind.controller.NodeMouseMotionListener;
import freemind.main.FreeMindMain;
import freemind.main.Tools;
import freemind.modes.MindMap;
import freemind.modes.Mode;
import freemind.modes.ModesCreator;
import freemind.view.MapModule;
import freemind.view.mindmapview.MapView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class Controller {
    private LastOpenedList lastOpened;
    private MapModuleManager mapModuleManager;
    private HistoryManager history = new HistoryManager();
    private Map modes;
    private Mode mode;
    private FreeMindMain frame;
    private JToolBar toolbar;
    private NodeMouseMotionListener nodeMouseMotionListener;
    private NodeKeyListener nodeKeyListener;
    private NodeDragListener nodeDragListener;
    private NodeDropListener nodeDropListener;
    private MapMouseMotionListener mapMouseMotionListener;
    private MapMouseWheelListener mapMouseWheelListener;
    private ModesCreator modescreator = new ModesCreator(this);
    private PageFormat pageFormat = null;
    private PrinterJob printerJob = null;
    private Icon bswatch = new BackgroundSwatch();
    private boolean antialiasEdges = false;
    private boolean antialiasAll = false;
    private Map fontMap = new HashMap();
    boolean isPrintingAllowed = true;
    boolean menubarVisible = true;
    boolean toolbarVisible = true;
    boolean leftToolbarVisible = true;
    Action close;
    Action print;
    Action printDirect;
    Action page;
    public Action quit;
    Action background;
    Action optionAntialiasAction;
    Action optionHTMLExportFoldingAction;
    Action optionSelectionMechanismAction;
    Action about;
    Action faq;
    Action documentation;
    Action license;
    Action historyPreviousMap;
    Action historyNextMap;
    Action navigationPreviousMap;
    Action navigationNextMap;
    Action moveToRoot;
    Action toggleMenubar;
    Action toggleToolbar;
    Action toggleLeftToolbar;
    Action zoomIn;
    Action zoomOut;
    private static final String[] zooms = new String[]{"25%", "40%", "60%", "75%", "100%", "125%", "150%", "200%"};

    public Controller(FreeMindMain frame) {
        this.checkJavaVersion();
        this.frame = frame;
        this.modes = this.modescreator.getAllModes();
        this.mapModuleManager = new MapModuleManager(this);
        this.lastOpened = new LastOpenedList(this, this.getProperty("lastOpened"));
        this.nodeMouseMotionListener = new NodeMouseMotionListener(this);
        this.nodeKeyListener = new NodeKeyListener(this);
        this.nodeDragListener = new NodeDragListener(this);
        this.nodeDropListener = new NodeDropListener(this);
        this.mapMouseMotionListener = new MapMouseMotionListener(this);
        this.mapMouseWheelListener = new MapMouseWheelListener(this);
        this.close = new CloseAction(this);
        this.print = new PrintAction(this, true);
        this.printDirect = new PrintAction(this, false);
        this.page = new PageAction(this);
        this.quit = new QuitAction(this);
        this.background = new BackgroundAction(this, this.bswatch);
        this.about = new AboutAction(this);
        this.faq = new OpenFAQAction(this);
        this.documentation = new DocumentationAction(this);
        this.license = new LicenseAction(this);
        this.historyPreviousMap = new HistoryPreviousMapAction(this);
        this.historyNextMap = new HistoryNextMapAction(this);
        this.navigationPreviousMap = new NavigationPreviousMapAction(this);
        this.navigationNextMap = new NavigationNextMapAction(this);
        this.toggleMenubar = new ToggleMenubarAction(this);
        this.toggleToolbar = new ToggleToolbarAction(this);
        this.toggleLeftToolbar = new ToggleLeftToolbarAction(this);
        this.optionAntialiasAction = new OptionAntialiasAction(this);
        this.optionHTMLExportFoldingAction = new OptionHTMLExportFoldingAction(this);
        this.optionSelectionMechanismAction = new OptionSelectionMechanismAction(this);
        this.zoomIn = new ZoomInAction(this);
        this.zoomOut = new ZoomOutAction(this);
        this.moveToRoot = new MoveToRootAction(this);
        this.toolbar = new MainToolBar(this);
        this.getFrame().getContentPane().add((Component)this.toolbar, "North");
        this.setAllActions(false);
        if (!Tools.isAvailableFontFamily(this.getProperty("standardfont"))) {
            System.out.println("Warning: the font you have set as standard - " + this.getProperty("standardfont") + " - is not available.");
            frame.setProperty("standardfont", "SansSerif");
        }
    }

    public void checkJavaVersion() {
        if (System.getProperty("java.version").compareTo("1.4.0") < 0) {
            String message = "Warning: FreeMind requires version Java 1.4.0 or higher (your version: " + System.getProperty("java.version") + ").";
            System.err.println(message);
            JOptionPane.showMessageDialog(null, message, "FreeMind", 2);
        }
    }

    public String getProperty(String property) {
        return this.frame.getProperty(property);
    }

    public void setProperty(String property, String value) {
        this.frame.setProperty(property, value);
    }

    public FreeMindMain getFrame() {
        return this.frame;
    }

    public URL getResource(String resource) {
        return this.getFrame().getResource(resource);
    }

    public String getResourceString(String resource) {
        try {
            return this.frame.getResources().getString(resource);
        }
        catch (Exception ex) {
            System.err.println("Warning - resource string not found:" + resource);
            return resource;
        }
    }

    public MindMap getModel() {
        if (this.getMapModule() != null) {
            return this.getMapModule().getModel();
        }
        return null;
    }

    public MapView getView() {
        if (this.getMapModule() != null) {
            return this.getMapModule().getView();
        }
        System.err.println("[Freemind-Developer-Internal-Warning (do not write a bug report, please)]: Tried to get view without being able to get map module.");
        return null;
    }

    Map getModes() {
        return this.modes;
    }

    public Mode getMode() {
        return this.mode;
    }

    public String[] getZooms() {
        return zooms;
    }

    public MapModuleManager getMapModuleManager() {
        return this.mapModuleManager;
    }

    public LastOpenedList getLastOpenedList() {
        return this.lastOpened;
    }

    private MapModule getMapModule() {
        return this.getMapModuleManager().getMapModule();
    }

    private JToolBar getToolBar() {
        return this.toolbar;
    }

    public Font getFontThroughMap(Font font) {
        if (!this.fontMap.containsKey(font.toString())) {
            this.fontMap.put(font.toString(), font);
        }
        return (Font)this.fontMap.get(font.toString());
    }

    public void setAntialiasEdges(boolean antialiasEdges) {
        this.antialiasEdges = antialiasEdges;
    }

    public void setAntialiasAll(boolean antialiasAll) {
        this.antialiasAll = antialiasAll;
    }

    public boolean getAntialiasEdges() {
        return this.antialiasEdges;
    }

    public boolean getAntialiasAll() {
        return this.antialiasAll;
    }

    public Font getDefaultFont() {
        int fontSize = Integer.parseInt(this.getFrame().getProperty("defaultfontsize"));
        int fontStyle = Integer.parseInt(this.getFrame().getProperty("defaultfontstyle"));
        String fontFamily = this.getProperty("defaultfont");
        return this.getFontThroughMap(new Font(fontFamily, fontStyle, fontSize));
    }

    public boolean changeToMode(String mode) {
        if (this.getMode() != null && mode.equals(((Object)this.getMode()).toString())) {
            return true;
        }
        Mode newmode = (Mode)this.modes.get(mode);
        if (newmode == null) {
            this.errorMessage(this.getResourceString("mode_na") + ": " + mode);
            return false;
        }
        if (this.getMode() != null && this.getMode().getModeToolBar() != null) {
            this.toolbar.remove(this.getMode().getModeToolBar());
        }
        if (this.getMode() != null && this.getMode().getLeftToolBar() != null) {
            this.getFrame().getContentPane().remove(this.getMode().getLeftToolBar());
        }
        if (this.getMapModule() != null) {
            this.getMapModuleManager().setMapModule(null);
            this.getMapModuleManager().mapModuleChanged();
        }
        this.mode = newmode;
        if (this.getMode().getModeToolBar() != null) {
            this.toolbar.add(this.getMode().getModeToolBar());
            this.getMode().getModeToolBar().repaint();
        }
        if (this.getMode().getLeftToolBar() != null) {
            this.getFrame().getContentPane().add((Component)this.getMode().getLeftToolBar(), "West");
            this.getMode().getLeftToolBar().repaint();
        }
        this.toolbar.validate();
        this.toolbar.repaint();
        this.setTitle();
        this.getMode().activate();
        this.getFrame().getFreeMindMenuBar().updateFileMenu();
        this.getFrame().getFreeMindMenuBar().updateEditMenu();
        if (this.getMapModule() == null) {
            this.setAllActions(false);
        }
        Object[] messageArguments = new Object[]{((Object)this.getMode()).toString()};
        MessageFormat formatter = new MessageFormat(this.getResourceString("mode_status"));
        this.getFrame().out(formatter.format(messageArguments));
        return true;
    }

    public void setMenubarVisible(boolean visible) {
        this.menubarVisible = visible;
        this.getFrame().getFreeMindMenuBar().setVisible(this.menubarVisible);
    }

    public void setToolbarVisible(boolean visible) {
        this.toolbarVisible = visible;
        this.toolbar.setVisible(this.toolbarVisible);
    }

    public void setLeftToolbarVisible(boolean visible) {
        if (this.getMode() != null && this.getMode().getLeftToolBar() != null) {
            this.leftToolbarVisible = visible;
            this.getMode().getLeftToolBar().setVisible(this.leftToolbarVisible);
        }
    }

    public NodeKeyListener getNodeKeyListener() {
        return this.nodeKeyListener;
    }

    public NodeMouseMotionListener getNodeMouseMotionListener() {
        return this.nodeMouseMotionListener;
    }

    public MapMouseMotionListener getMapMouseMotionListener() {
        return this.mapMouseMotionListener;
    }

    public MapMouseWheelListener getMapMouseWheelListener() {
        return this.mapMouseWheelListener;
    }

    public NodeDragListener getNodeDragListener() {
        return this.nodeDragListener;
    }

    public NodeDropListener getNodeDropListener() {
        return this.nodeDropListener;
    }

    public void setFrame(FreeMindMain frame) {
        this.frame = frame;
    }

    void moveToRoot() {
        if (this.getMapModule() != null) {
            this.getView().moveToRoot();
        }
    }

    public void informationMessage(Object message) {
        JOptionPane.showMessageDialog(this.getFrame().getContentPane(), message.toString(), "FreeMind", 1);
    }

    public void informationMessage(Object message, JComponent component) {
        JOptionPane.showMessageDialog(component, message.toString(), "FreeMind", 1);
    }

    public void errorMessage(Object message) {
        JOptionPane.showMessageDialog(this.getFrame().getContentPane(), message.toString(), "FreeMind", 0);
    }

    public void errorMessage(Object message, JComponent component) {
        JOptionPane.showMessageDialog(component, message.toString(), "FreeMind", 0);
    }

    public void obtainFocusForSelected() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (Controller.this.getView() != null) {
                    Controller.this.getView().getSelected().requestFocus();
                } else {
                    Controller.this.getFrame().getFreeMindMenuBar().requestFocus();
                }
            }
        });
    }

    public void setZoom(float zoom) {
        this.getView().setZoom(zoom);
        ((MainToolBar)this.toolbar).setZoomComboBox(zoom);
        Object[] messageArguments = new Object[]{String.valueOf(zoom * 100.0f)};
        MessageFormat formatter = new MessageFormat(this.getResourceString("user_defined_zoom_status_bar"));
        this.getFrame().out(formatter.format(messageArguments));
    }

    public void setTitle() {
        Object[] messageArguments = new Object[]{((Object)this.getMode()).toString()};
        MessageFormat formatter = new MessageFormat(this.getResourceString("mode_title"));
        String title = formatter.format(messageArguments);
        if (this.getMapModule() != null) {
            title = title + " - " + this.getMapModule().toString() + (this.getMapModule().getModel().isReadOnly() ? " (" + this.getResourceString("read_only") + ")" : "");
        }
        this.getFrame().setTitle(title);
    }

    private void setAllActions(boolean enabled) {
        this.background.setEnabled(enabled);
        if (this.isPrintingAllowed) {
            this.print.setEnabled(enabled);
            this.printDirect.setEnabled(enabled);
            this.page.setEnabled(enabled);
        } else {
            this.print.setEnabled(false);
            this.printDirect.setEnabled(false);
            this.page.setEnabled(false);
        }
        this.close.setEnabled(enabled);
        this.moveToRoot.setEnabled(enabled);
        ((MainToolBar)this.getToolBar()).setAllActions(enabled);
    }

    private void quit() {
        String currentMapRestorable;
        String string = currentMapRestorable = this.getModel() != null ? this.getModel().getRestoreable() : null;
        while (this.getView() != null) {
            boolean closingNotCancelled = this.getMapModuleManager().close();
            if (closingNotCancelled) continue;
            return;
        }
        String lastOpenedString = this.lastOpened.save();
        this.setProperty("lastOpened", lastOpenedString);
        if (currentMapRestorable != null) {
            this.getFrame().setProperty("onStartIfNotSpecified", currentMapRestorable);
        }
        this.setProperty("toolbarVisible", this.toolbarVisible ? "true" : "false");
        this.setProperty("leftToolbarVisible", this.leftToolbarVisible ? "true" : "false");
        this.setProperty("antialiasEdges", this.antialiasEdges ? "true" : "false");
        this.setProperty("antialiasAll", this.antialiasAll ? "true" : "false");
        this.setProperty("appwindow_width", String.valueOf(this.getFrame().getWinWidth()));
        this.setProperty("appwindow_height", String.valueOf(this.getFrame().getWinHeight()));
        this.setProperty("appwindow_state", String.valueOf(this.getFrame().getWinState()));
        this.getFrame().saveProperties();
        System.exit(0);
    }

    private boolean acquirePrinterJobAndPageFormat() {
        if (this.printerJob == null) {
            try {
                this.printerJob = PrinterJob.getPrinterJob();
            }
            catch (SecurityException ex) {
                this.isPrintingAllowed = false;
                return false;
            }
        }
        this.pageFormat = this.pageFormat == null ? this.printerJob.defaultPage() : this.pageFormat;
        return true;
    }

    private class OpenFAQAction
    extends AbstractAction {
        Controller c;

        OpenFAQAction(Controller controller2) {
            super(controller2.getResourceString("FAQ"), new ImageIcon(controller2.getResource("images/Link.png")));
            this.c = controller2;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.c.getFrame().openDocument(new URL("http://freemind.sourceforge.net/faq.html"));
            }
            catch (MalformedURLException ex) {
                this.c.errorMessage(this.c.getResourceString("url_error") + "\n" + ex);
            }
            catch (Exception ex) {
                this.c.errorMessage(ex);
            }
        }
    }

    private class OptionSelectionMechanismAction
    extends AbstractAction {
        Controller c;

        OptionSelectionMechanismAction(Controller controller2) {
            this.c = controller2;
        }

        public void actionPerformed(ActionEvent e) {
            Controller.this.setProperty("selection_method", e.getActionCommand());
            NodeMouseMotionListener.updateSelectionMethod(this.c);
            String statusBarString = this.c.getResourceString(e.getActionCommand());
            if (statusBarString != null) {
                this.c.getFrame().out(statusBarString);
            }
        }
    }

    private class OptionHTMLExportFoldingAction
    extends AbstractAction {
        OptionHTMLExportFoldingAction(Controller controller2) {
        }

        public void actionPerformed(ActionEvent e) {
            Controller.this.setProperty("html_export_folding", e.getActionCommand());
        }
    }

    private class OptionAntialiasAction
    extends AbstractAction {
        OptionAntialiasAction(Controller controller2) {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("antialias_none")) {
                Controller.this.setAntialiasEdges(false);
                Controller.this.setAntialiasAll(false);
            }
            if (e.getActionCommand().equals("antialias_edges")) {
                Controller.this.setAntialiasEdges(true);
                Controller.this.setAntialiasAll(false);
            }
            if (e.getActionCommand().equals("antialias_all")) {
                Controller.this.setAntialiasEdges(false);
                Controller.this.setAntialiasAll(true);
            }
            if (Controller.this.getView() != null) {
                Controller.this.getView().repaint();
            }
        }
    }

    private class BackgroundAction
    extends AbstractAction {
        BackgroundAction(Controller controller2, Icon icon) {
            super(controller2.getResourceString("background"), icon);
        }

        public void actionPerformed(ActionEvent e) {
            Color color = JColorChooser.showDialog(Controller.this.getView(), "Choose Background Color:", Controller.this.getView().getBackground());
            Controller.this.getModel().setBackgroundColor(color);
        }
    }

    private class BackgroundSwatch
    extends ColorSwatch {
        private BackgroundSwatch() {
        }

        Color getColor() {
            return Controller.this.getModel().getBackgroundColor();
        }
    }

    protected class ZoomOutAction
    extends AbstractAction {
        public ZoomOutAction(Controller controller2) {
            super(controller2.getResourceString("zoom_out"));
        }

        public void actionPerformed(ActionEvent e) {
            ((MainToolBar)Controller.this.toolbar).zoomOut();
        }
    }

    protected class ZoomInAction
    extends AbstractAction {
        public ZoomInAction(Controller controller2) {
            super(controller2.getResourceString("zoom_in"));
        }

        public void actionPerformed(ActionEvent e) {
            ((MainToolBar)Controller.this.toolbar).zoomIn();
        }
    }

    private class ToggleLeftToolbarAction
    extends AbstractAction {
        ToggleLeftToolbarAction(Controller controller2) {
            super(controller2.getResourceString("toggle_left_toolbar"));
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent event) {
            Controller.this.leftToolbarVisible = !Controller.this.leftToolbarVisible;
            Controller.this.setLeftToolbarVisible(Controller.this.leftToolbarVisible);
        }
    }

    private class ToggleToolbarAction
    extends AbstractAction {
        ToggleToolbarAction(Controller controller2) {
            super(controller2.getResourceString("toggle_toolbar"));
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent event) {
            Controller.this.toolbarVisible = !Controller.this.toolbarVisible;
            Controller.this.setToolbarVisible(Controller.this.toolbarVisible);
        }
    }

    private class ToggleMenubarAction
    extends AbstractAction {
        ToggleMenubarAction(Controller controller2) {
            super(controller2.getResourceString("toggle_menubar"));
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent event) {
            Controller.this.menubarVisible = !Controller.this.menubarVisible;
            Controller.this.setMenubarVisible(Controller.this.menubarVisible);
        }
    }

    private class MoveToRootAction
    extends AbstractAction {
        MoveToRootAction(Controller controller2) {
            super(controller2.getResourceString("move_to_root"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent event) {
            Controller.this.moveToRoot();
        }
    }

    private class NavigationNextMapAction
    extends AbstractAction {
        NavigationNextMapAction(Controller controller2) {
            super(controller2.getResourceString("next_map"), new ImageIcon(Controller.this.getResource("images/Forward24.gif")));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent event) {
            Controller.this.mapModuleManager.nextMapModule();
        }
    }

    private class NavigationPreviousMapAction
    extends AbstractAction {
        NavigationPreviousMapAction(Controller controller2) {
            super(controller2.getResourceString("previous_map"), new ImageIcon(Controller.this.getResource("images/Back24.gif")));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent event) {
            Controller.this.mapModuleManager.previousMapModule();
        }
    }

    private class HistoryNextMapAction
    extends AbstractAction {
        HistoryNextMapAction(Controller controller2) {
            super(controller2.getResourceString("next_map"), new ImageIcon(Controller.this.getResource("images/Forward24.gif")));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent event) {
            Controller.this.history.nextMap();
        }
    }

    private class HistoryPreviousMapAction
    extends AbstractAction {
        HistoryPreviousMapAction(Controller controller2) {
            super(controller2.getResourceString("previous_map"), new ImageIcon(Controller.this.getResource("images/Back24.gif")));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent event) {
            Controller.this.history.previousMap();
        }
    }

    private class LicenseAction
    extends AbstractAction {
        Controller controller;

        LicenseAction(Controller controller2) {
            super(controller2.getResourceString("license"));
            this.controller = controller2;
        }

        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(Controller.this.getView(), this.controller.getResourceString("license_text"));
        }
    }

    private class AboutAction
    extends AbstractAction {
        Controller controller;

        AboutAction(Controller controller2) {
            super(controller2.getResourceString("about"));
            this.controller = controller2;
        }

        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(Controller.this.getFrame().getViewport(), this.controller.getResourceString("about_text") + "0.7.1");
        }
    }

    private class DocumentationAction
    extends AbstractAction {
        Controller controller;

        DocumentationAction(Controller controller2) {
            super(controller2.getResourceString("documentation"));
            this.controller = controller2;
        }

        public void actionPerformed(ActionEvent e) {
            Controller.this.changeToMode("Browse");
        }
    }

    private class PageAction
    extends AbstractAction {
        Controller controller;

        PageAction(Controller controller2) {
            super(controller2.getResourceString("page"));
            this.controller = controller2;
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            if (!Controller.this.acquirePrinterJobAndPageFormat()) {
                return;
            }
            final JDialog dialog = new JDialog((JFrame)((Object)Controller.this.getFrame()), Controller.this.getResourceString("printing_settings"), true);
            JCheckBox fitToPage = new JCheckBox(Controller.this.getResourceString("fit_to_page"), Tools.safeEquals("true", Controller.this.getProperty("fit_to_page")));
            JLabel userZoomL = new JLabel(Controller.this.getResourceString("user_zoom"));
            final JTextField userZoom = new JTextField(Controller.this.getProperty("user_zoom"), 3);
            userZoom.setEditable(!fitToPage.isSelected());
            JButton okButton = new JButton(Controller.this.getResourceString("ok"));
            final Tools.IntHolder eventSource = new Tools.IntHolder();
            JPanel panel = new JPanel();
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            eventSource.setValue(0);
            okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    eventSource.setValue(1);
                    dialog.dispose();
                }
            });
            fitToPage.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    userZoom.setEditable(e.getStateChange() == 2);
                }
            });
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 2;
            gridbag.setConstraints(fitToPage, c);
            panel.add(fitToPage);
            c.gridy = 1;
            c.gridwidth = 1;
            gridbag.setConstraints(userZoomL, c);
            panel.add(userZoomL);
            c.gridx = 1;
            c.gridwidth = 1;
            gridbag.setConstraints(userZoom, c);
            panel.add(userZoom);
            c.gridy = 2;
            c.gridx = 0;
            c.gridwidth = 3;
            c.insets = new Insets(10, 0, 0, 0);
            gridbag.setConstraints(okButton, c);
            panel.add(okButton);
            panel.setLayout(gridbag);
            dialog.setDefaultCloseOperation(2);
            dialog.setContentPane(panel);
            dialog.setLocationRelativeTo((JFrame)((Object)Controller.this.getFrame()));
            dialog.getRootPane().setDefaultButton(okButton);
            dialog.pack();
            dialog.show();
            if (eventSource.getValue() != 1) {
                return;
            }
            Controller.this.setProperty("user_zoom", userZoom.getText());
            Controller.this.setProperty("fit_to_page", fitToPage.isSelected() ? "true" : "false");
            Controller.this.pageFormat = Controller.this.printerJob.pageDialog(Controller.this.pageFormat);
        }
    }

    private class PrintAction
    extends AbstractAction {
        Controller controller;
        boolean isDlg;

        PrintAction(Controller controller2, boolean isDlg) {
            super(controller2.getResourceString("print"), new ImageIcon(Controller.this.getResource("images/Print24.gif")));
            this.controller = controller2;
            this.setEnabled(false);
            this.isDlg = isDlg;
        }

        public void actionPerformed(ActionEvent e) {
            if (!Controller.this.acquirePrinterJobAndPageFormat()) {
                return;
            }
            Controller.this.printerJob.setPrintable(Controller.this.getView(), Controller.this.pageFormat);
            if (!this.isDlg || Controller.this.printerJob.printDialog()) {
                try {
                    Controller.this.printerJob.print();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private class CloseAction
    extends AbstractAction {
        CloseAction(Controller controller2) {
            super(controller2.getResourceString("close"));
        }

        public void actionPerformed(ActionEvent e) {
            Controller.this.getMapModuleManager().close();
        }
    }

    private class QuitAction
    extends AbstractAction {
        QuitAction(Controller controller2) {
            super(controller2.getResourceString("quit"));
        }

        public void actionPerformed(ActionEvent e) {
            Controller.this.quit();
        }
    }

    private class HistoryManager {
        private LinkedList historyList = new LinkedList();
        private int current;

        HistoryManager() {
        }

        void nextMap() {
        }

        void previousMap() {
        }

        void mapChanged(MapModule map) {
        }
    }

    public class MapModuleManager {
        private Map mapModules = new HashMap();
        private MapModule mapModule;
        private Controller c;

        MapModuleManager(Controller c) {
            this.c = c;
        }

        Map getMapModules() {
            return this.mapModules;
        }

        public MapModule getMapModule() {
            return this.mapModule;
        }

        public void newMapModule(MindMap map) {
            MapModule mapModule = new MapModule(map, new MapView(map, this.c), Controller.this.getMode());
            this.setMapModule(mapModule);
            this.addToMapModules(mapModule.toString(), mapModule);
            Controller.this.history.mapChanged(mapModule);
            this.updateNavigationActions();
        }

        public void updateMapModuleName() {
            this.getMapModules().remove(this.getMapModule().toString());
            this.getMapModule().rename();
            this.addToMapModules(this.getMapModule().toString(), this.getMapModule());
        }

        void nextMapModule() {
            int index;
            LinkedList keys = new LinkedList(this.getMapModules().keySet());
            ListIterator i = keys.listIterator((index = keys.indexOf(this.getMapModule().toString())) + 1);
            if (i.hasNext()) {
                this.changeToMapModule((String)i.next());
            } else if (keys.iterator().hasNext()) {
                this.changeToMapModule((String)keys.iterator().next());
            }
        }

        void previousMapModule() {
            int index;
            LinkedList keys = new LinkedList(this.getMapModules().keySet());
            ListIterator i = keys.listIterator(index = keys.indexOf(this.getMapModule().toString()));
            if (i.hasPrevious()) {
                this.changeToMapModule((String)i.previous());
            } else {
                ListIterator last = keys.listIterator(keys.size() - 1);
                if (last.hasNext()) {
                    this.changeToMapModule((String)last.next());
                }
            }
        }

        public boolean tryToChangeToMapModule(String mapModule) {
            if (mapModule != null && this.getMapModules().containsKey(mapModule)) {
                this.changeToMapModule(mapModule);
                return true;
            }
            return false;
        }

        void changeToMapModule(String mapModule) {
            MapModule map = (MapModule)this.getMapModules().get(mapModule);
            Controller.this.history.mapChanged(map);
            this.changeToMapModuleWithoutHistory(map);
        }

        void changeToMapModuleWithoutHistory(MapModule map) {
            if (map.getMode() != Controller.this.getMode()) {
                Controller.this.changeToMode(((Object)map.getMode()).toString());
            }
            this.setMapModule(map);
            this.mapModuleChanged();
        }

        public void changeToMapOfMode(Mode mode) {
            for (String next : this.getMapModules().keySet()) {
                if (((MapModule)this.getMapModules().get(next)).getMode() != mode) continue;
                this.changeToMapModule(next);
                return;
            }
        }

        private void mapModuleChanged() {
            Controller.this.frame.getFreeMindMenuBar().updateMapsMenu();
            Controller.this.lastOpened.mapOpened(this.getMapModule());
            Controller.this.frame.getFreeMindMenuBar().updateLastOpenedList();
            Controller.this.setTitle();
            this.updateZoomBar();
            this.c.obtainFocusForSelected();
        }

        private void setMapModule(MapModule mapModule) {
            this.mapModule = mapModule;
            Controller.this.frame.setView(mapModule != null ? mapModule.getView() : null);
        }

        private void addToMapModules(String key, MapModule value) {
            String extension = "";
            int count = 1;
            while (this.mapModules.containsKey(key + extension)) {
                extension = "<" + ++count + ">";
            }
            value.setName(key + extension);
            this.mapModules.put(key + extension, value);
            Controller.this.setAllActions(true);
            Controller.this.moveToRoot();
            this.mapModuleChanged();
        }

        private void changeToAnotherMap(String toBeClosed) {
            LinkedList keys = new LinkedList(this.getMapModules().keySet());
            ListIterator i = keys.listIterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                if (key.equals(toBeClosed)) continue;
                this.changeToMapModule(key);
                return;
            }
        }

        private void updateNavigationActions() {
            LinkedList keys = new LinkedList(this.getMapModules().keySet());
            Controller.this.navigationPreviousMap.setEnabled(keys.size() > 1);
            Controller.this.navigationNextMap.setEnabled(keys.size() > 1);
        }

        private void updateZoomBar() {
            if (this.getMapModule() != null) {
                ((MainToolBar)this.c.toolbar).setZoomComboBox(this.getMapModule().getView().getZoom());
            }
        }

        private boolean close() {
            boolean closingNotCancelled = Controller.this.getMode().getModeController().close();
            if (!closingNotCancelled) {
                return false;
            }
            String toBeClosed = this.getMapModule().toString();
            this.mapModules.remove(toBeClosed);
            if (this.mapModules.isEmpty()) {
                Controller.this.setAllActions(false);
                this.setMapModule(null);
                Controller.this.frame.setView(null);
            } else {
                this.changeToMapModule((String)this.mapModules.keySet().iterator().next());
                this.updateNavigationActions();
            }
            this.mapModuleChanged();
            return true;
        }
    }
}

