/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.modes.MindMapLink;
import freemind.modes.MindMapLinkRegistry;
import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.MindMapNodeModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LinkRegistryAdapter
implements MindMapLinkRegistry {
    protected HashMap TargetToID = new HashMap();
    protected HashMap IDToLinks = new HashMap();
    protected HashMap IDToCuttedLinks = new HashMap();
    private static Logger logger = Logger.getAnonymousLogger();

    public LinkRegistryAdapter() {
        logger.setLevel(Level.WARNING);
        logger.info("New Registry");
    }

    protected String generateUniqueID(String proposedID) {
        String returnValue;
        Random ran = new Random();
        String myProposedID = new String(proposedID != null ? proposedID : "");
        if (!myProposedID.startsWith("_")) {
            myProposedID = "_" + myProposedID;
        }
        do {
            if (!myProposedID.equals("")) {
                returnValue = myProposedID;
                myProposedID = "";
                continue;
            }
            returnValue = "Freemind_Link_" + Integer.toString(ran.nextInt(2000000000));
        } while (this.IDToLinks.containsKey(returnValue));
        return returnValue;
    }

    public MindMapLinkRegistry.ID_Registered registerLinkTarget(MindMapNode target) {
        return this.registerLinkTarget(target, null);
    }

    public MindMapLinkRegistry.ID_Registered registerLinkTarget(MindMapNode target, String proposedID) {
        MindMapLinkRegistry.ID_BasicState state;
        if (this.TargetToID.containsKey(target) && (state = (MindMapLinkRegistry.ID_BasicState)this.TargetToID.get(target)) instanceof MindMapLinkRegistry.ID_Registered) {
            return (MindMapLinkRegistry.ID_Registered)state;
        }
        String newID = this.generateUniqueID(proposedID);
        ID_RegisteredAdapter state2 = new ID_RegisteredAdapter(target, newID);
        this.TargetToID.put(target, state2);
        logger.info("Register target node:" + target + ", with ID=" + newID);
        this.getAssignedLinksVector(state2);
        return state2;
    }

    public MindMapLinkRegistry.ID_BasicState getState(MindMapNode node) {
        if (this.TargetToID.containsKey(node)) {
            return (MindMapLinkRegistry.ID_BasicState)this.TargetToID.get(node);
        }
        return new ID_BlankAdapter();
    }

    protected String getIDString(MindMapNode node) {
        if (this.TargetToID.containsKey(node)) {
            MindMapLinkRegistry.ID_BasicState state = (MindMapLinkRegistry.ID_BasicState)this.TargetToID.get(node);
            return state.getID();
        }
        return null;
    }

    public MindMapNode getTargetForID(String ID) {
        for (MindMapNode target : this.TargetToID.keySet()) {
            MindMapLinkRegistry.ID_BasicState state = (MindMapLinkRegistry.ID_BasicState)this.TargetToID.get(target);
            if (!(state instanceof MindMapLinkRegistry.ID_Registered) || !state.getID().equals(ID)) continue;
            return target;
        }
        return null;
    }

    private Vector getAssignedLinksVector(MindMapLinkRegistry.ID_Registered state) {
        Vector vec;
        String id = state.getID();
        if (this.IDToLinks.containsKey(id)) {
            vec = (Vector)this.IDToLinks.get(id);
        } else {
            vec = new Vector();
            this.IDToLinks.put(id, vec);
        }
        logger.fine("getAssignedLinksVector " + vec);
        return vec;
    }

    public void deregisterLinkTarget(MindMapNode target) throws IllegalArgumentException {
        MindMapLinkRegistry.ID_BasicState state = this.getState(target);
        if (state instanceof MindMapLinkRegistry.ID_Registered) {
            Vector vec = this.getAssignedLinksVector((MindMapLinkRegistry.ID_Registered)state);
            for (int i = vec.size() - 1; i >= 0; --i) {
                this.deregisterLink((MindMapLink)vec.get(i));
            }
            logger.info("Deregister target node:" + target);
            this.TargetToID.remove(target);
        }
    }

    public void registerLink(MindMapLink link) throws IllegalArgumentException {
        if (link.getSource() == null || link.getTarget() == null || link.getDestinationLabel() == null) {
            throw new IllegalArgumentException("Illegal link specification." + link);
        }
        MindMapNode source = link.getSource();
        MindMapNode target = link.getTarget();
        MindMapLinkRegistry.ID_Registered state = this.registerLinkTarget(target);
        Vector vec = this.getAssignedLinksVector(state);
        for (int i = 0; i < vec.size(); ++i) {
            if (vec.get(i) != link) continue;
            return;
        }
        vec.add(link);
        logger.info("Register link (" + link + ") from source node:" + source + " to target " + target);
    }

    public void deregisterLink(MindMapLink link) {
        MindMapNode source = link.getSource();
        MindMapNode target = link.getTarget();
        MindMapLinkRegistry.ID_Registered state = this.registerLinkTarget(target);
        Vector vec = this.getAssignedLinksVector(state);
        for (int i = vec.size() - 1; i >= 0; --i) {
            logger.fine("Test for equal node:" + source + " to vector(i) " + vec.get(i));
            if (vec.get(i) != link) continue;
            vec.removeElementAt(i);
            logger.info("Deregister link  (" + link + ") from source node:" + source + " to target " + target);
        }
    }

    public Vector getAllSources(MindMapNode target) {
        Vector<MindMapNode> returnValue = new Vector<MindMapNode>();
        MindMapLinkRegistry.ID_BasicState state = this.getState(target);
        if (state instanceof MindMapLinkRegistry.ID_Registered) {
            Vector vec = this.getAssignedLinksVector((MindMapLinkRegistry.ID_Registered)state);
            for (int i = 0; i < vec.size(); ++i) {
                returnValue.add(((MindMapLink)vec.get(i)).getSource());
            }
        }
        return returnValue;
    }

    public Vector getAllLinks(MindMapNode node) {
        Vector returnValue = new Vector();
        returnValue.addAll(this.getAllLinksIntoMe(node));
        returnValue.addAll(this.getAllLinksFromMe(node));
        logger.fine("All links  (" + returnValue + ") from  node:" + node);
        return returnValue;
    }

    public Vector getAllLinksIntoMe(MindMapNode target) {
        Vector returnValue = new Vector();
        MindMapLinkRegistry.ID_BasicState state = this.getState(target);
        if (this.getState(target) instanceof MindMapLinkRegistry.ID_Registered) {
            Vector vec = this.getAssignedLinksVector((MindMapLinkRegistry.ID_Registered)state);
            returnValue.addAll(vec);
        }
        return returnValue;
    }

    public Vector getAllLinksFromMe(MindMapNode source) {
        Vector<MindMapLink> returnValue = new Vector<MindMapLink>();
        Collection values = this.IDToLinks.values();
        for (Vector linkVector : values) {
            for (int j = 0; j < linkVector.size(); ++j) {
                MindMapLink link = (MindMapLink)linkVector.get(j);
                if (link.getSource() != source) continue;
                returnValue.add(link);
            }
        }
        return returnValue;
    }

    public String getLabel(MindMapNode target) {
        MindMapLinkRegistry.ID_BasicState state = this.getState(target);
        if (this.getState(target) instanceof MindMapLinkRegistry.ID_Registered) {
            return ((MindMapLinkRegistry.ID_Registered)state).getID();
        }
        return null;
    }

    public void cutNode(MindMapNode target) {
        logger.entering("LinkRegistryAdapter", "cutNode", target);
        MindMapLinkRegistry.ID_BasicState state = this.getState(target);
        if (state instanceof MindMapLinkRegistry.ID_Registered) {
            Vector vec;
            String id = this.getIDString(target);
            if (this.IDToCuttedLinks.containsKey(id)) {
                vec = (Vector)this.IDToCuttedLinks.get(id);
                vec.clear();
            } else {
                vec = new Vector();
                this.IDToCuttedLinks.put(id, vec);
            }
            Vector links = this.getAllLinksIntoMe(target);
            for (int i = links.size() - 1; i >= 0; --i) {
                MindMapLink link = (MindMapLink)links.get(i);
                vec.add(link);
                logger.info("Adding link (" + link + ") to target " + target + " to the cutted nodes from (old) id " + id);
                this.deregisterLink(link);
            }
            this.deregisterLinkTarget(target);
        }
        Vector links = this.getAllLinksFromMe(target);
        for (int i = links.size() - 1; i >= 0; --i) {
            MindMapLink link = (MindMapLink)links.get(i);
            this.deregisterLink(link);
        }
        ListIterator e = target.childrenUnfolded();
        while (e.hasNext()) {
            MindMapNodeModel child = (MindMapNodeModel)e.next();
            this.cutNode((MindMapNode)child);
        }
        logger.exiting("LinkRegistryAdapter", "cutNode", target);
    }

    public void clearCuttedNodeBuffer() {
        this.IDToCuttedLinks.clear();
    }

    public Vector getCuttedNode(String oldTargetID) {
        Vector vec;
        if (this.IDToCuttedLinks.containsKey(oldTargetID)) {
            vec = (Vector)this.IDToCuttedLinks.get(oldTargetID);
            for (int i = 0; i < vec.size(); ++i) {
                vec.set(i, ((MindMapLink)vec.get(i)).clone());
            }
            logger.info("returning link repository (" + vec + ") the cutted nodes with old id " + oldTargetID);
        } else {
            vec = new Vector();
        }
        return vec;
    }

    protected class ID_RegisteredAdapter
    extends ID_UsedStateAdapter
    implements MindMapLinkRegistry.ID_Registered {
        public ID_RegisteredAdapter(MindMapNode target, String ID) {
            super(target, ID);
        }
    }

    protected abstract class ID_UsedStateAdapter
    extends ID_BasicStateAdapter
    implements MindMapLinkRegistry.ID_UsedState {
        protected MindMapNode target;

        public MindMapNode getTarget() {
            return this.target;
        }

        public ID_UsedStateAdapter(MindMapNode target, String ID) {
            this.target = target;
            this.ID = ID;
        }

        protected ID_UsedStateAdapter() {
        }

        protected void clone(ID_UsedStateAdapter state) {
            this.target = state.target;
            this.ID = state.ID;
        }
    }

    public class ID_BlankAdapter
    extends ID_BasicStateAdapter
    implements MindMapLinkRegistry.ID_Blank {
    }

    public class ID_BasicStateAdapter
    implements MindMapLinkRegistry.ID_BasicState {
        protected String ID;

        public String getID() {
            return this.ID;
        }

        public String toString() {
            return "ID_BasicState, ID=" + (this.ID == null ? "null" : this.ID);
        }
    }
}

