/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.main.FreeMindMain;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import freemind.view.mindmapview.RootNodeView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JLabel;

public class MindMapLayout
implements LayoutManager {
    private final int BORDER = 30;
    private final int HGAP_BASE = 20;
    private final int VGAP = 3;
    private MapView map;
    private int ySize;
    private int totalXSize;

    public MindMapLayout(MapView map) {
        this.map = map;
        this.ySize = Integer.parseInt(this.getFrame().getProperty("mapysize"));
        this.totalXSize = Integer.parseInt(this.getFrame().getProperty("mapxsize"));
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public void layoutContainer(Container parent) {
        this.layout(this.map.getRoot());
    }

    public void layout() {
        this.layout(this.map.getRoot());
    }

    private void layout(NodeView node) {
        int x = 0;
        int hgap = this.map.getZoomed(20);
        x = node.isRoot() ? 0 : (node.isLeft() ? -hgap - node.getPreferredSize().width : node.getParentView().getPreferredSize().width + hgap);
        this.placeNode(node, x, node.relYPos);
        ListIterator e = node.getChildrenViews().listIterator();
        while (e.hasNext()) {
            this.layout((NodeView)e.next());
        }
    }

    private void placeNode(NodeView node, int relativeX, int relativeY) {
        if (node.isRoot()) {
            node.setBounds(this.totalXSize / 2 - node.getPreferredSize().width / 2, this.ySize / 2 - node.getPreferredSize().height / 2, node.getPreferredSize().width, node.getPreferredSize().height);
        } else {
            int x = node.getParentView().getLocation().x + relativeX;
            int y = node.getParentView().getLocation().y + relativeY;
            if (x < 0 || x + node.getPreferredSize().width > this.map.getSize().width) {
                if (node.isLeft()) {
                    this.resizeMap(x);
                } else {
                    this.resizeMap(x + node.getPreferredSize().width);
                }
                return;
            }
            node.setBounds(x, y, node.getPreferredSize().width, node.getPreferredSize().height);
            JLabel label = node.getEdge().getLabel();
            Point start = node.getParentView().getOutPoint();
            Point end = node.getInPoint();
            if (node.getParentView().isRoot() && node.isLeft()) {
                start = node.getParentView().getInPoint();
            }
            node.getEdge().start = start;
            node.getEdge().end = end;
            int relX = (start.x - end.x) / 2;
            int absX = start.x - relX;
            int relY = (start.y - end.y) / 2;
            int absY = start.y - relY;
            label.setBounds(absX - label.getPreferredSize().width / 2, absY - label.getPreferredSize().height / 2, label.getPreferredSize().width, label.getPreferredSize().height);
        }
    }

    public void resizeMap(int outmostX) {
        int oldTotalXSize = this.totalXSize;
        this.totalXSize = 60 + (outmostX < 0 ? this.totalXSize + -outmostX : outmostX);
        this.getMapView().setSize(this.totalXSize, this.ySize);
        this.getMapView().scrollBy((this.totalXSize - oldTotalXSize) / 2, 0);
        this.layout(this.map.getRoot());
    }

    void updateTreeHeightsAndRelativeYOfDescendantsAndAncestors(NodeView node) {
        this.updateTreeHeightsAndRelativeYOfDescendants(node);
        this.updateTreeHeightsAndRelativeYOfAncestors(node);
    }

    void updateTreeHeightsAndRelativeYOfAncestors(NodeView node) {
        if (node.isRoot()) {
            this.updateRelativeYOfChildren(node);
        } else {
            this.updateTreeHeightFromChildren(node);
            this.updateRelativeYOfChildren(node);
            this.updateTreeHeightsAndRelativeYOfAncestors(node.getParentView());
        }
    }

    void updateTreeHeightsAndRelativeYOfWholeMap() {
        this.updateTreeHeightsAndRelativeYOfDescendants(this.getRoot());
    }

    void updateTreeHeightsAndRelativeYOfDescendants(NodeView node) {
        ListIterator e = node.getChildrenViews().listIterator();
        while (e.hasNext()) {
            this.updateTreeHeightsAndRelativeYOfDescendants((NodeView)e.next());
        }
        this.updateTreeHeightFromChildren(node);
        this.updateRelativeYOfChildren(node);
    }

    private void updateRelativeYOfChildren(NodeView node) {
        if (node.isRoot()) {
            NodeView child;
            int pointer = -(this.sumOfAlreadyComputedTreeHeights(this.getRoot().getLeft()) / 2);
            ListIterator e = this.getRoot().getLeft().listIterator();
            while (e.hasNext()) {
                child = (NodeView)e.next();
                child.relYPos = (pointer += child.getTreeHeight() / 2) - 2;
                pointer += child.getTreeHeight() / 2;
            }
            pointer = -(this.sumOfAlreadyComputedTreeHeights(this.getRoot().getRight()) / 2);
            e = this.getRoot().getRight().listIterator();
            while (e.hasNext()) {
                child = (NodeView)e.next();
                child.relYPos = (pointer += child.getTreeHeight() / 2) - 2;
                pointer += child.getTreeHeight() / 2;
            }
        } else {
            int pointer = (node.getPreferredSize().height - node.getTreeHeight()) / 2;
            if (node.getModel().getCloud() != null) {
                pointer = (int)((float)pointer + 15.0f * this.getMapView().getZoom());
            }
            ListIterator it = node.getChildrenViews().listIterator();
            while (it.hasNext()) {
                NodeView child = (NodeView)it.next();
                child.relYPos = pointer + (child.getTreeHeight() - child.getPreferredSize().height) / 2 - 2;
                pointer += child.getTreeHeight();
            }
        }
    }

    private int sumOfAlreadyComputedTreeHeights(LinkedList v) {
        if (v == null || v.size() == 0) {
            return 0;
        }
        int height = 0;
        ListIterator e = v.listIterator();
        while (e.hasNext()) {
            NodeView node = (NodeView)e.next();
            if (node == null) continue;
            height += node.getTreeHeight();
        }
        return height;
    }

    protected void updateTreeHeightFromChildren(NodeView node) {
        int iHeight = Math.max(this.sumOfAlreadyComputedTreeHeights(node.getChildrenViews()), node.getPreferredSize().height + 3);
        if (node.getModel().getCloud() != null) {
            iHeight = (int)((float)iHeight + 30.0f * this.getMapView().getZoom());
        }
        node.setTreeHeight(iHeight);
    }

    private RootNodeView getRoot() {
        return (RootNodeView)this.map.getRoot();
    }

    private MapView getMapView() {
        return this.map;
    }

    private FreeMindMain getFrame() {
        return this.map.getController().getFrame();
    }

    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(200, 200);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(this.totalXSize, this.ySize);
    }
}

