/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.main.Tools;
import freemind.modes.MindIcon;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.view.mindmapview.BezierEdgeView;
import freemind.view.mindmapview.BubbleNodeView;
import freemind.view.mindmapview.EdgeView;
import freemind.view.mindmapview.ForkNodeView;
import freemind.view.mindmapview.LinearEdgeView;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.MultipleImage;
import freemind.view.mindmapview.RootNodeView;
import freemind.view.mindmapview.SharpBezierEdgeView;
import freemind.view.mindmapview.SharpLinearEdgeView;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.net.MalformedURLException;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public abstract class NodeView
extends JLabel {
    protected MindMapNode model;
    protected MapView map;
    protected EdgeView edge;
    protected static final Color selectedColor = new Color(210, 210, 210);
    protected static final Color dragColor = Color.lightGray;
    protected int treeHeight;
    private boolean left = true;
    int relYPos;
    private boolean isLong = false;
    public static final int DRAGGED_OVER_NO = 0;
    public static final int DRAGGED_OVER_SON = 1;
    public static final int DRAGGED_OVER_SIBLING = 2;
    public static final int DRAGGED_OVER_SON_LEFT = 3;
    protected int isDraggedOver = 0;
    static final int ALIGN_BOTTOM = -1;
    static final int ALIGN_CENTER = 0;
    static final int ALIGN_TOP = 1;
    public final int LEFT_WIDTH_OVERHEAD = 0;
    public final int LEFT_HEIGHT_OVERHEAD = 0;

    public void setDraggedOver(int draggedOver) {
        this.isDraggedOver = draggedOver;
    }

    public void setDraggedOver(Point p) {
        this.setDraggedOver(this.dropAsSibling(p.getX()) ? 2 : 1);
    }

    public int getDraggedOver() {
        return this.isDraggedOver;
    }

    protected NodeView(MindMapNode model, MapView map) {
        this.model = model;
        this.setMap(map);
        if (!this.isRoot()) {
            if (this.getModel().getEdge().getStyle().equals("linear")) {
                this.edge = new LinearEdgeView(this.getParentView(), this);
            } else if (this.getModel().getEdge().getStyle().equals("bezier")) {
                this.edge = new BezierEdgeView(this.getParentView(), this);
            } else if (this.getModel().getEdge().getStyle().equals("sharp_linear")) {
                this.edge = new SharpLinearEdgeView(this.getParentView(), this);
            } else if (this.getModel().getEdge().getStyle().equals("sharp_bezier")) {
                this.edge = new SharpBezierEdgeView(this.getParentView(), this);
            } else {
                System.err.println("Unknown Edge Type.");
            }
        }
        this.addMouseListener(map.getNodeMouseMotionListener());
        this.addMouseMotionListener(map.getNodeMouseMotionListener());
        this.addKeyListener(map.getNodeKeyListener());
        this.addDragListener(map.getNodeDragListener());
        this.addDropListener(map.getNodeDropListener());
    }

    void addDragListener(DragGestureListener dgl) {
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 0x40000003, dgl);
    }

    void addDropListener(DropTargetListener dtl) {
        DropTarget dropTarget = new DropTarget(this, dtl);
        dropTarget.setActive(true);
    }

    protected static NodeView newNodeView(MindMapNode model, MapView map) {
        NodeView newView;
        if (model.isRoot()) {
            newView = new RootNodeView(model, map);
        } else if (model.getStyle().equals("fork")) {
            newView = new ForkNodeView(model, map);
        } else if (model.getStyle().equals("bubble")) {
            newView = new BubbleNodeView(model, map);
        } else {
            System.err.println("Tried to create a NodeView of unknown Style.");
            newView = new ForkNodeView(model, map);
        }
        model.setViewer(newView);
        map.add(newView);
        newView.update();
        return newView;
    }

    public boolean dropAsSibling(double xCoord) {
        return this.isLeft() ? xCoord > (double)(this.getSize().width * 2 / 3) : xCoord < (double)(this.getSize().width / 3);
    }

    public boolean dropPosition(double xCoord) {
        return this.isLeft();
    }

    public boolean followLink(double xCoord) {
        return this.getModel().getLink() != null && (this.getModel().isRoot() || !this.getModel().hasChildren() || xCoord < (double)(this.getSize().width / 2));
    }

    public void updateCursor(double xCoord) {
        int requiredCursor;
        int n = requiredCursor = this.followLink(xCoord) ? 12 : 0;
        if (this.getCursor().getType() != requiredCursor) {
            this.setCursor(new Cursor(requiredCursor));
        }
    }

    public boolean isRoot() {
        return this.model.isRoot();
    }

    public boolean getIsLong() {
        return this.isLong;
    }

    public boolean isSiblingOf(NodeView myNodeView) {
        return this.getParentView() == myNodeView.getParentView();
    }

    public boolean isChildOf(NodeView myNodeView) {
        return this.getParentView() == myNodeView;
    }

    public boolean isParentOf(NodeView myNodeView) {
        return this == myNodeView.getParentView();
    }

    public MindMapNode getModel() {
        return this.model;
    }

    public void getCoordinates(LinkedList inList, int additionalDistanceForConvexHull) {
        inList.addLast(new Point(-additionalDistanceForConvexHull + this.getX(), -additionalDistanceForConvexHull + this.getY()));
        inList.addLast(new Point(-additionalDistanceForConvexHull + this.getX(), additionalDistanceForConvexHull + this.getY() + this.getHeight()));
        inList.addLast(new Point(additionalDistanceForConvexHull + this.getX() + this.getWidth(), additionalDistanceForConvexHull + this.getY() + this.getHeight()));
        inList.addLast(new Point(additionalDistanceForConvexHull + this.getX() + this.getWidth(), -additionalDistanceForConvexHull + this.getY()));
        LinkedList childrenViews = this.getChildrenViews();
        ListIterator children_it = childrenViews.listIterator();
        while (children_it.hasNext()) {
            NodeView child = (NodeView)children_it.next();
            child.getCoordinates(inList, additionalDistanceForConvexHull);
        }
    }

    public Dimension getPreferredSize() {
        if (this.map.isPrinting()) {
            return new Dimension(super.getPreferredSize().width + (int)(10.0f * this.map.getZoom()), super.getPreferredSize().height);
        }
        return super.getPreferredSize();
    }

    public void requestFocus() {
        this.map.getController().getMode().getModeController().anotherNodeSelected(this.getModel());
        super.requestFocus();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    public void paintSelected(Graphics2D graphics, Dimension size) {
        if (this.isSelected()) {
            graphics.setColor(selectedColor);
            graphics.fillRect(0, 0, size.width, size.height);
        }
    }

    public void paintDragOver(Graphics2D graphics, Dimension size) {
        if (this.isDraggedOver == 1) {
            if (this.isLeft()) {
                graphics.setPaint(new GradientPaint(size.width * 3 / 4, 0.0f, this.map.getBackground(), size.width / 4, 0.0f, dragColor));
                graphics.fillRect(0, 0, size.width * 3 / 4, size.height - 1);
            } else {
                graphics.setPaint(new GradientPaint(size.width / 4, 0.0f, this.map.getBackground(), size.width * 3 / 4, 0.0f, dragColor));
                graphics.fillRect(size.width / 4, 0, size.width - 1, size.height - 1);
            }
        }
        if (this.isDraggedOver == 2) {
            graphics.setPaint(new GradientPaint(0.0f, size.height * 3 / 5, this.map.getBackground(), 0.0f, size.height / 5, dragColor));
            graphics.fillRect(0, 0, size.width - 1, size.height - 1);
        }
    }

    public int getLeftWidthOverhead() {
        return 0;
    }

    int getTreeHeight() {
        return this.treeHeight;
    }

    void setTreeHeight(int treeHeight) {
        this.treeHeight = treeHeight;
    }

    protected boolean isSelected() {
        return this.getMap().isSelected(this);
    }

    public boolean isLeft() {
        if (this.getModel().isLeft() == null) {
            return true;
        }
        return this.getModel().isLeft().getValue();
    }

    protected void setLeft(boolean left) {
        this.getModel().setLeft(left);
    }

    protected void setModel(MindMapNode model) {
        this.model = model;
    }

    MapView getMap() {
        return this.map;
    }

    protected void setMap(MapView map) {
        this.map = map;
    }

    EdgeView getEdge() {
        return this.edge;
    }

    void setEdge(EdgeView edge) {
        this.edge = edge;
    }

    protected NodeView getParentView() {
        return this.getModel().getParentNode().getViewer();
    }

    public LinkedList getChildrenViews() {
        LinkedList<NodeView> childrenViews = new LinkedList<NodeView>();
        ListIterator it = this.getModel().childrenUnfolded();
        if (it != null) {
            while (it.hasNext()) {
                NodeView view = ((MindMapNode)it.next()).getViewer();
                if (view == null) continue;
                childrenViews.add(view);
            }
        }
        return childrenViews;
    }

    protected LinkedList getSiblingViews() {
        return this.getParentView().getChildrenViews();
    }

    Point getOutPoint() {
        Dimension size = this.getSize();
        if (this.isRoot()) {
            return new Point(this.getLocation().x + size.width, this.getLocation().y + size.height / 2);
        }
        if (this.isLeft()) {
            return new Point(this.getLocation().x, this.getLocation().y + size.height - 2);
        }
        return new Point(this.getLocation().x + size.width, this.getLocation().y + size.height - 2);
    }

    Point getInPoint() {
        Dimension size = this.getSize();
        if (this.isRoot()) {
            return new Point(this.getLocation().x, this.getLocation().y + size.height / 2);
        }
        if (this.isLeft()) {
            return new Point(this.getLocation().x + size.width, this.getLocation().y + size.height - 2);
        }
        return new Point(this.getLocation().x, this.getLocation().y + size.height - 2);
    }

    Point getLinkPoint() {
        Dimension size = this.getSize();
        if (this.isRoot()) {
            return new Point(this.getLocation().x, this.getLocation().y + size.height / 2);
        }
        if (this.isLeft()) {
            return new Point(this.getLocation().x, this.getLocation().y + size.height / 2);
        }
        return new Point(this.getLocation().x + size.width, this.getLocation().y + size.height / 2);
    }

    int getAlignment() {
        if (this.isRoot()) {
            return 0;
        }
        return -1;
    }

    protected NodeView getNextPage() {
        if (this.isRoot()) {
            return this;
        }
        NodeView sibling = this.getNextSibling();
        if (sibling == this) {
            return this;
        }
        for (NodeView nextSibling = sibling.getNextSibling(); nextSibling != sibling && sibling.getParentView() == nextSibling.getParentView(); nextSibling = nextSibling.getNextSibling()) {
            sibling = nextSibling;
        }
        return sibling;
    }

    protected NodeView getPreviousPage() {
        if (this.isRoot()) {
            return this;
        }
        NodeView sibling = this.getPreviousSibling();
        if (sibling == this) {
            return this;
        }
        for (NodeView previousSibling = sibling.getPreviousSibling(); previousSibling != sibling && sibling.getParentView() == previousSibling.getParentView(); previousSibling = previousSibling.getPreviousSibling()) {
            sibling = previousSibling;
        }
        return sibling;
    }

    protected NodeView getNextSibling() {
        NodeView sibling;
        NodeView nextSibling = this;
        for (sibling = this; !sibling.isRoot() && sibling == (nextSibling = sibling.getNextSiblingSingle()); sibling = sibling.getParentView()) {
        }
        if (sibling.isRoot()) {
            return this;
        }
        sibling = nextSibling;
        while (sibling.getModel().getNodeLevel() < this.getMap().getSiblingMaxLevel() && sibling.getChildrenViews().size() > 0) {
            sibling = (NodeView)sibling.getChildrenViews().getFirst();
        }
        return sibling;
    }

    protected NodeView getPreviousSibling() {
        NodeView sibling;
        NodeView previousSibling = this;
        for (sibling = this; !sibling.isRoot() && sibling == (previousSibling = sibling.getPreviousSiblingSingle()); sibling = sibling.getParentView()) {
        }
        if (sibling.isRoot()) {
            return this;
        }
        sibling = previousSibling;
        while (sibling.getModel().getNodeLevel() < this.getMap().getSiblingMaxLevel() && sibling.getChildrenViews().size() > 0) {
            sibling = (NodeView)sibling.getChildrenViews().getLast();
        }
        return sibling;
    }

    protected NodeView getNextSiblingSingle() {
        LinkedList v = null;
        v = this.getParentView().isRoot() ? (this.isLeft() ? ((RootNodeView)this.getParentView()).getLeft() : ((RootNodeView)this.getParentView()).getRight()) : this.getParentView().getChildrenViews();
        NodeView sibling = v.size() - 1 == v.indexOf(this) ? this : (NodeView)v.get(v.indexOf(this) + 1);
        return sibling;
    }

    protected NodeView getPreviousSiblingSingle() {
        LinkedList v = null;
        v = this.getParentView().isRoot() ? (this.isLeft() ? ((RootNodeView)this.getParentView()).getLeft() : ((RootNodeView)this.getParentView()).getRight()) : this.getParentView().getChildrenViews();
        NodeView sibling = v.indexOf(this) <= 0 ? this : (NodeView)v.get(v.indexOf(this) - 1);
        return sibling;
    }

    void insert() {
        ListIterator it = this.getModel().childrenFolded();
        while (it.hasNext()) {
            this.insert((MindMapNode)it.next());
        }
    }

    void insert(MindMapNode newNode) {
        NodeView newView = NodeView.newNodeView(newNode, this.getMap());
        newView.setLeft(this.isLeft());
        ListIterator it = newNode.childrenFolded();
        while (it.hasNext()) {
            MindMapNode child = (MindMapNode)it.next();
            newView.insert(child);
        }
    }

    void remove() {
        this.getMap().remove(this);
        if (this.getEdge() != null) {
            this.getEdge().remove();
        }
        this.getModel().setViewer(null);
        ListIterator e = this.getChildrenViews().listIterator();
        while (e.hasNext()) {
            ((NodeView)e.next()).remove();
        }
    }

    void update() {
        Color color = this.getModel().getColor();
        if (color == null) {
            String stdcolor = this.map.getController().getProperty("standardnodecolor");
            color = stdcolor.length() == 7 ? Tools.xmlToColor(stdcolor) : Color.black;
        }
        this.setForeground(color);
        MultipleImage iconImages = new MultipleImage(this.map.getZoom());
        boolean iconPresent = false;
        Vector icons = ((NodeAdapter)this.getModel()).getIcons();
        for (int i = 0; i < icons.size(); ++i) {
            iconPresent = true;
            MindIcon myicon = (MindIcon)icons.get(i);
            iconImages.addImage((ImageIcon)myicon.getIcon(this.map.getController().getFrame()));
        }
        String link = ((NodeAdapter)this.getModel()).getLink();
        if (link != null) {
            iconPresent = true;
            ImageIcon icon = new ImageIcon(((NodeAdapter)this.getModel()).getFrame().getResource(link.startsWith("mailto:") ? "images/Mail.png" : (Tools.executableByExtension(link) ? "images/Executable.png" : "images/Link.png")));
            iconImages.addImage(icon);
        }
        this.setIcon(iconPresent ? iconImages : null);
        Font font = this.getModel().getFont();
        Font font2 = font = font == null ? this.map.getController().getDefaultFont() : font;
        if (font != null) {
            if (this.map.getZoom() != 1.0f) {
                font = font.deriveFont((float)font.getSize() * this.map.getZoom());
            }
            this.setFont(font);
        } else {
            System.err.println("NodeView.update(): default font is null.");
        }
        String nodeText = ((Object)this.getModel()).toString();
        if (nodeText.length() < 4) {
            nodeText = nodeText + new String("   ").substring(nodeText.length());
        }
        String[] lines = nodeText.split("\n");
        boolean widthMustBeRestricted = false;
        lines = nodeText.split("\n");
        for (int line = 0; line < lines.length; ++line) {
            this.setText(lines[line]);
            widthMustBeRestricted = this.getPreferredSize().width > this.map.getZoomed(this.map.getMaxNodeWidth());
            if (widthMustBeRestricted) break;
        }
        boolean bl = this.isLong = widthMustBeRestricted || lines.length > 1;
        if (nodeText.startsWith("<html>")) {
            if (nodeText.indexOf("<img") >= 0 && nodeText.indexOf("<base ") < 0) {
                try {
                    nodeText = "<html><base href=\"" + this.map.getModel().getURL() + "\">" + nodeText.substring(6);
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            this.setText(nodeText);
        } else if (nodeText.startsWith("<table>")) {
            lines[0] = lines[0].substring(7);
            int startingLine = lines[0].matches("\\s*") ? 1 : 0;
            String text = "<html><table border=1 style=\"border-color: white\">";
            for (int line = startingLine; line < lines.length; ++line) {
                text = text + "<tr><td style=\"border-color: white;\">" + Tools.toXMLEscapedText(lines[line]).replaceAll("\t", "<td style=\"border-color: white\">");
            }
            this.setText(text);
        } else if (this.isLong) {
            String text = "<tr><td>";
            int maximumLineLength = 0;
            for (int line = 0; line < lines.length; ++line) {
                text = text + Tools.toXMLEscapedTextWithNBSPizedSpaces(lines[line]) + "<p>";
                if (lines[line].length() <= maximumLineLength) continue;
                maximumLineLength = lines[line].length();
            }
            text = text + "</td></tr>";
            this.setText("<html><table" + (!widthMustBeRestricted ? ">" : " width=\"" + this.map.getZoomed(this.map.getMaxNodeWidth()) + "\">") + text + "</table></html>");
        }
        this.repaint();
    }

    void updateAll() {
        this.update();
        ListIterator e = this.getChildrenViews().listIterator();
        while (e.hasNext()) {
            NodeView child = (NodeView)e.next();
            child.updateAll();
        }
    }

    protected void setRendering(Graphics2D g) {
        if (this.map.getController().getAntialiasAll()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }
}

