# -*- coding: iso-8859-1 -*-
"""
    MoinMoin - Email activation of new accounts

    EmailActivation causes new accounts to be disabled when created.
    They must be activated via a URL that is emailed to the address
    entered into the account is created.  Unactivated accounts
    expire and then are deleted.  This is the entry point for
    the EmailActivation action, which is called when a POST from
    the URL emailed is acted upon.  The POST will be asking the
    new account to be ether activated or cancelled.

    @copyright: 2007 by MoinMoin:RussellStuart
    @license: GNU GPL, see COPYING for details.
"""


#
# Confirm account creation. 
#
from MoinMoin import Page
from MoinMoin import wikiutil

def execute(pagename, request):
    #
    # The code is held in the macro with the same name.  We just defer to it.
    #
    me = __name__.split(".")[-1]
    action = wikiutil.importPlugin(
            request.cfg, "macro", me, function="action")
    message, html = action(pagename, request)
    if message:
        pagename = request.cfg.page_front_page
    Page.Page(request, pagename).send_page(request, msg=message)
