# -*- coding: iso-8859-1 -*-
"""
    MoinMoin - Email activation of new accounts

    EmailActivation causes new accounts to be disabled when created.
    They must be activated via a URL that is emailed to the address
    entered into the account is created.  Unactivated accounts
    expire and then are deleted.  This file over rides the
    standard MoinMoin userform action.  It does the same thing as
    the standard useform action, but after that is complete a new
    account has been created it is disabled, and an email sent to
    the user asking him to enable it.

    @copyright: 2007 by MoinMoin:RussellStuart
    @license: GNU GPL, see COPYING for details.
"""

#
# This allows the administrator to undisable him when he is
# authenticated.
#
from   MoinMoin import Page
from   MoinMoin import user
from   MoinMoin import userform
from   MoinMoin import wikiutil
import os
import time

def execute(pagename, request):
    #
    # Execute the form identically to how wikiaction.do_userform()
    # does it.
    #
    form = request.form
    if not form.has_key('name'):
        userName = None
    else:
	userName = form['name'][0]
    isCreate = (
        form.has_key('create') or
        form.has_key('create_only') or
        form.has_key('create_and_mail'))
    isCreate = 1	# Spammers bypass activation by not setting the above
    isNewUser = userName and not user.getUserId(request, userName)
    message = userform.savedata(request)
    #
    # If that created a new user then generate a cookie and
    # see if he wants to send an email.
    #
    if isCreate and isNewUser:
	password = form['password'][0]
	u = user.User(request, auth_username=userName, password=password)
        if u.exists():
	    userform_action = wikiutil.importPlugin(
		    request.cfg, "macro", "EmailActivation",
		    function="userform_action")
	    new_message = userform_action(request, u)
	    if new_message != None:
		message = new_message
    Page.Page(request, pagename).send_page(request, msg=message)
