﻿# -*- coding: utf-8 -*-
"""
    MoinMoin technical theme

    @copyright: (c) 2003-2004 by Nir Soffer
    @license: GNU GPL, see COPYING for details.
"""

from MoinMoin.theme import modern


class Theme(modern.Theme):

    name = "technical"

    def header(self, d, **kw):
        """ Assemble wiki header
        
        @param d: parameter dictionary
        @rtype: unicode
        @return: page header html
        """
        html = [
            # Pre header custom html
            self.emit_custom_html(self.cfg.page_header1),
            
            # Header
            u'<div id="header">',
            self.logo(),
            self.searchform(d),
            self.username(d),
            self.trail(d),
            self.navibar(d),
            u'<div id="pageline"><hr style="display:none;"></div>',
            u'</div>',
            
            # Post header custom html (not recommended)
            self.emit_custom_html(self.cfg.page_header2),
            
            # Start of page
            self.startPage(),
            u'<div id="page-top">',
            self.msg(d),
            self.editbar(d),
            u'</div>',
            u'<div id="page-content">',
            self.title(d),
        ]
        return u'\n'.join(html)

    def footer(self, d, **keywords):
        """ Assemble wiki footer
        
        @param d: parameter dictionary
        @keyword ...:...
        @rtype: unicode
        @return: page footer html
        """
        page = d['page']
        html = [
            # End of page
            self.pageinfo(page),
            u'</div>',
            u'<div id="page-bottom">',
            self.editbar(d),
            u'</div>',
            self.endPage(),
            
            # Pre footer custom html (not recommended!)
            self.emit_custom_html(self.cfg.page_footer1),
            
            # Footer
            u'<div id="footer">',
            self.credits(d),
            self.showversion(d, **keywords),
            u'</div>',
            
            # Post footer custom html
            self.emit_custom_html(self.cfg.page_footer2),
            ]
        return u'\n'.join(html)

        
def execute(request):
    """ Generate and return a theme object
        
    @param request: the request object
    @rtype: Theme instance
    @return: Theme object
    """
    return Theme(request)

