Imports System.IO
Imports System.Environment

'
' Copyright (c) 2007-2008, Alexander "Loki" Agibalov
'

Public Class Form1
    Private newDoc As Microsoft.Office.Interop.Word.Document
    Private newDocWin As Microsoft.Office.Interop.Word.Window
    Private docPath As String

    Private Sub Button_start_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_start.Click
        Dim sFilename As String
        Dim Doc As Microsoft.Office.Interop.Word.Document
        Dim wrd As Microsoft.Office.Interop.Word.Application
        
        Dim result As DialogResult = OpenFileDialog1.ShowDialog()
        If (result = Windows.Forms.DialogResult.OK) Then
            sFilename = OpenFileDialog1.FileName
        Else
            Exit Sub
        End If

        SetStatus("Starting MS Word")
        Try
            wrd = CreateObject("Word.Application")
        Catch exWrd As Exception
            Console.WriteLine("couldn't initialize word activex")
            Console.WriteLine(exWrd.Message)
            MsgBox("Failed to start MS Word")
            Exit Sub
        End Try
        SetStatus("Opening file")
        wrd.Documents.Open(sFilename)
        Doc = wrd.ActiveDocument
        newDocWin = Doc.ActiveWindow
        newDocWin.Selection.WholeStory()
        newDocWin.Selection.Copy()
        docPath = Doc.Path & "\"
        Doc.Close(Microsoft.Office.Interop.Word.WdSaveOptions.wdDoNotSaveChanges)
        wrd.Documents.Add()
        SetStatus("Creating document copy")
        newDoc = wrd.ActiveDocument
        newDocWin = newDoc.ActiveWindow
        newDoc.ShowSpellingErrors = False
        newDoc.ShowGrammaticalErrors = False
        newDocWin.Selection.Paste()

        SetStatus("Parsing headers")
        MakeWikiTOC()
        SetStatus("Converting images")
        MakeWikiConvertShapes()
        SetStatus("Saving image files to disk")
        SaveImages()
        SetStatus("Replacing images with links")
        MakeWikiDelImages()
        SetStatus("Processing styles")
        MakeWikiStyles()
        SetStatus("Removing empty headers")
        newDocWin.Selection.HomeKey(Unit:=Microsoft.Office.Interop.Word.WdUnits.wdStory)
        MakeWikiDelEmptyHeaders()
        SetStatus("Replacing bold and italic text")
        newDocWin.Selection.HomeKey(Unit:=Microsoft.Office.Interop.Word.WdUnits.wdStory)
        MakeWikiItalicBold()
        newDocWin.Selection.HomeKey(Unit:=Microsoft.Office.Interop.Word.WdUnits.wdStory)
        MakeWikiItalic()
        newDocWin.Selection.HomeKey(Unit:=Microsoft.Office.Interop.Word.WdUnits.wdStory)
        MakeWikiBold()
        newDocWin.Selection.HomeKey(Unit:=Microsoft.Office.Interop.Word.WdUnits.wdStory)
        SetStatus("Removing page breaks")
        MakeWikiDelPagebreaks()
        newDocWin.Selection.HomeKey(Unit:=Microsoft.Office.Interop.Word.WdUnits.wdStory)
        newDocWin.Selection.WholeStory()
        SetStatus("Parsing links")
        MakeWikiBookmarks()
        newDocWin.Selection.HomeKey(Unit:=Microsoft.Office.Interop.Word.WdUnits.wdStory)
        newDocWin.Selection.WholeStory()
        SetStatus("Converting tables")
        MakeWikiTableALL()
        SetStatus("Processing links")
        MakeWikiLists()
        SetStatus("Removing empty headers")
        newDocWin.Selection.HomeKey(Unit:=Microsoft.Office.Interop.Word.WdUnits.wdStory)
        MakeWikiDelEmptyHeaders()
        SetStatus("Finalizing")
        newDocWin.Selection.WholeStory()
        newDocWin.Selection.Style = Microsoft.Office.Interop.Word.WdBuiltinStyle.wdStylePlainText
        newDocWin.View.ShowAll = False

        newDocWin.Selection.Copy()
        newDoc.Close(Microsoft.Office.Interop.Word.WdSaveOptions.wdDoNotSaveChanges)

        TextBox1.Enabled = True
        TextBox1.Text = Clipboard.GetData(System.Windows.Forms.DataFormats.Text)

        ZipImages()
        Button_copy.Enabled = True
    End Sub

    Private Sub SetStatus(ByVal stat As String)
        Label_status.Text = stat
        Label_status.Refresh()
    End Sub

    Private Sub MakeWikiTOC()
        If newDoc.TablesOfContents.Count > 0 Then
            newDoc.TablesOfContents(1).Range.Select()
            newDocWin.Selection.Style = Microsoft.Office.Interop.Word.WdBuiltinStyle.wdStyleNormal
            newDocWin.Selection.Text = "<<TableOfContents(5)>>" & vbCr
        End If
    End Sub

    Private Sub MakeWikiConvertShapes()
        Dim sShp As Microsoft.Office.Interop.Word.Shape
        Dim iShp As Microsoft.Office.Interop.Word.InlineShape
        For Each sShp In newDoc.Shapes
            sShp.Select()
            iShp = sShp.ConvertToInlineShape
        Next
    End Sub

    Private Sub SaveImages()
        Dim lPicNumber, cnt As Integer
        Dim totalimg = newDoc.InlineShapes.Count
        Dim s As Microsoft.Office.Interop.Word.InlineShape
        Dim tempDir As String = My.Computer.FileSystem.SpecialDirectories.Temp & "\word2wiki"
        If Directory.Exists(tempDir) Then
            Dim fls(), st As String
            fls = Directory.GetFiles(tempDir)
            For Each st In fls
                If File.Exists(st) Then File.Delete(st)
            Next
        Else : Directory.CreateDirectory(tempDir)
        End If
        lPicNumber = 1
        cnt = newDoc.InlineShapes.Count
        For Each s In newDoc.InlineShapes
            SetStatus("Saving image " & lPicNumber & " of " & cnt)
            Try
                s.Reset()
            Catch ex As Exception
                Console.WriteLine("couldn't reset the image number " & lPicNumber)
                Console.WriteLine(ex.Message)
            End Try
            's.PictureFormat.ColorType = Microsoft.Office.Core.MsoPictureColorType.msoPictureAutomatic
            s.Select()
            newDocWin.Selection.Copy()
            PictureBox1.Image = Clipboard.GetData(System.Windows.Forms.DataFormats.Bitmap)
            PictureBox1.Image.Save(tempDir & "\fig" & Format$(lPicNumber, "0#") & ".png", System.Drawing.Imaging.ImageFormat.Png)
            lPicNumber = lPicNumber + 1
        Next
    End Sub

    Private Function canZip() As Boolean
        Dim osInfo As OperatingSystem
        osInfo = OSVersion
        Dim ret = False
        If osInfo.Platform = PlatformID.Win32NT Then
            If osInfo.Version.Major > 4 Then
                If osInfo.Version.Minor > 0 Then ret = True
            End If
        End If
        Return ret
    End Function

    Private Function getVersion() As String
        Dim osInfo As OperatingSystem
        osInfo = OSVersion
        Dim ret = "noname"
        With osInfo
            If .Platform = PlatformID.Win32Windows Then
                Select Case (.Version.Minor)
                    Case 0
                        ret = "Windows 95"
                    Case 10
                        If .Version.Revision.ToString() = "2222A" Then
                            ret = "Windows 98 SE"
                        Else
                            ret = "Windows 98"
                        End If
                    Case 90
                        ret = "Windows Me"
                End Select
            ElseIf .Platform = PlatformID.Win32NT Then
                Select Case (.Version.Major)
                    Case 3
                        ret = "Windows NT 3.51"
                    Case 4
                        ret = "Windows NT 4.0"
                    Case 5
                        Select Case (.Version.Minor)
                            Case 0
                                ret = "Windows 2000"
                            Case 1
                                ret = "Windows XP"
                            Case 2
                                ret = "Windows Server 2003"
                        End Select
                    Case Else
                        ret = "Failed"
                End Select
            End If
        End With
        Return ret
    End Function


    Private Sub ZipImages()
        Dim tempDir As String = My.Computer.FileSystem.SpecialDirectories.Temp & "\word2wiki"

        If Not canZip() Then
            SetStatus("Images saved to " & tempDir)
            Exit Sub
        End If

        SetStatus("Zipping images")
        Dim emptyzip() As Byte = {80, 75, 5, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
        Dim zipFile As String = docPath & "doc_img.zip"
        Try
            If File.Exists(zipFile) Then File.Delete(zipFile)
            Dim fs As FileStream = New FileStream(zipFile, FileMode.CreateNew, FileAccess.Write, FileShare.None)
            fs.Write(emptyzip, 0, emptyzip.Length)
            fs.Close()
        Catch exf As Exception
            Console.WriteLine("couldn't create zip in a doc dir")
            Console.WriteLine(exf.Message)
            zipFile = tempDir & "\doc_img.zip"
            If File.Exists(zipFile) Then File.Delete(zipFile)
            Dim fs As FileStream = New FileStream(zipFile, FileMode.CreateNew, FileAccess.Write, FileShare.None)
            fs.Write(emptyzip, 0, emptyzip.Length)
            fs.Close()
        End Try

        Dim objShell As Shell32.Shell
        Dim objFolder As Shell32.Folder

        objShell = New Shell32.Shell
        objFolder = objShell.NameSpace(zipFile)

        If (Not objFolder Is Nothing) Then
            Dim fls(), st As String
            fls = Directory.GetFiles(tempDir)
            For Each st In fls
                If InStr(st, "doc_img.zip") = 0 Then objFolder.CopyHere(st)
            Next
        End If

        objFolder = Nothing
        objShell = Nothing

        System.Threading.Thread.Sleep(1000)
        SetStatus("Images saved to " & zipFile)
    End Sub

    Private Sub MakeWikiDelImages()
        Dim im As Microsoft.Office.Interop.Word.InlineShape
        Dim ShapesCnt, cnt As Integer
        ShapesCnt = 1
        cnt = newDoc.InlineShapes.Count
        For Each im In newDoc.InlineShapes
            SetStatus("Replacing image " & ShapesCnt & " of " & cnt)
            im.Select()
            newDocWin.Selection.Text = "{{attachment:" & "fig" & Format$(ShapesCnt, "0#") & ".png}}"
            ShapesCnt = ShapesCnt + 1
        Next im
    End Sub


    Private Sub MakeWikiStyles()
        Dim tbl As Microsoft.Office.Interop.Word.Table
        Dim rng As Microsoft.Office.Interop.Word.Range
        Dim stl, stl1, stl2, stl3, stl4, stln As Microsoft.Office.Interop.Word.Style
        Dim cnt, i As Integer
        stl1 = newDoc.Styles(Microsoft.Office.Interop.Word.WdBuiltinStyle.wdStyleHeading1)
        stl2 = newDoc.Styles(Microsoft.Office.Interop.Word.WdBuiltinStyle.wdStyleHeading2)
        stl3 = newDoc.Styles(Microsoft.Office.Interop.Word.WdBuiltinStyle.wdStyleHeading3)
        stl4 = newDoc.Styles(Microsoft.Office.Interop.Word.WdBuiltinStyle.wdStyleHeading4)
        stln = newDoc.Styles(Microsoft.Office.Interop.Word.WdBuiltinStyle.wdStyleNormal)
        cnt = newDoc.Paragraphs.Count
        '           ,    , ..  
        '    ,       
        For i = 1 To cnt
            SetStatus("Processing paragraph " & i & " of " & cnt)
            stl = newDoc.Paragraphs(i).Style
            If (stl Is stl1) Or (InStr(stl.NameLocal, " 1")) Or (InStr(stl.NameLocal, "Header 1")) Or (InStr(stl.NameLocal, " 1")) Then
                newDoc.Paragraphs(i).Style = Microsoft.Office.Interop.Word.WdBuiltinStyle.wdStyleNormal
                rng = newDoc.Range(Start:=newDoc.Paragraphs(i).Range.Start, End:=newDoc.Paragraphs(i).Range.End - 1)
                rng.InsertBefore("== ")
                rng.InsertAfter(" ==")
            ElseIf (stl Is stl2) Or (InStr(stl.NameLocal, " 2")) Or (InStr(stl.NameLocal, "Header 2")) Or (InStr(stl.NameLocal, " 2")) Then
                newDoc.Paragraphs(i).Style = Microsoft.Office.Interop.Word.WdBuiltinStyle.wdStyleNormal
                rng = newDoc.Range(Start:=newDoc.Paragraphs(i).Range.Start, End:=newDoc.Paragraphs(i).Range.End - 1)
                rng.InsertBefore("=== ")
                rng.InsertAfter(" ===")
            ElseIf (stl Is stl3) Or (InStr(stl.NameLocal, " 3")) Or (InStr(stl.NameLocal, "Header 3")) Or (InStr(stl.NameLocal, " 3")) Then
                newDoc.Paragraphs(i).Style = Microsoft.Office.Interop.Word.WdBuiltinStyle.wdStyleNormal
                rng = newDoc.Range(Start:=newDoc.Paragraphs(i).Range.Start, End:=newDoc.Paragraphs(i).Range.End - 1)
                rng.InsertBefore("==== ")
                rng.InsertAfter(" ====")
            ElseIf (stl Is stl4) Or (InStr(stl.NameLocal, " 4")) Or (InStr(stl.NameLocal, "Header 4")) Or (InStr(stl.NameLocal, " 4")) Then
                newDoc.Paragraphs(i).Style = Microsoft.Office.Interop.Word.WdBuiltinStyle.wdStyleNormal
                rng = newDoc.Range(Start:=newDoc.Paragraphs(i).Range.Start, End:=newDoc.Paragraphs(i).Range.End - 1)
                rng.InsertBefore("===== ")
                rng.InsertAfter(" =====")
            ElseIf (i < cnt - 1) Then
                If newDoc.Paragraphs(i).Range.Characters.Count > 1 Then
                    If newDoc.Paragraphs(i + 1).Range.Characters.Count > 1 Then
                        rng = newDoc.Range(Start:=newDoc.Paragraphs(i).Range.Start, End:=newDoc.Paragraphs(i).Range.End - 1)
                        rng.InsertAfter(" <<BR>>")
                    End If
                End If
            End If
        Next i

        '       :      
        SetStatus("Removing extra line brakes")
        For Each tbl In newDoc.Tables
            tbl.Select()
            newDocWin.Selection.Find.ClearFormatting()
            newDocWin.Selection.Find.Replacement.ClearFormatting()
            With newDocWin.Selection.Find
                .Text = "<<BR>>"
                .Replacement.Text = ""
                .Forward = True
                .Wrap = Microsoft.Office.Interop.Word.WdFindWrap.wdFindStop
                .Format = False
                .MatchCase = True
                .MatchWholeWord = False
                .MatchWildcards = False
                .MatchSoundsLike = False
                .MatchAllWordForms = False
            End With
            newDocWin.Selection.Find.Execute(Replace:=Microsoft.Office.Interop.Word.WdReplace.wdReplaceAll)
        Next tbl
    End Sub

    Private Sub MakeWikiDelEmptyHeaders()
        newDocWin.Selection.Find.ClearFormatting()
        newDocWin.Selection.Find.Replacement.ClearFormatting()
        With newDocWin.Selection.Find
            .Text = "^p====  ====^p"
            .Replacement.Text = "^p ^p"
            .Forward = True
            .Wrap = Microsoft.Office.Interop.Word.WdFindWrap.wdFindContinue
            .Format = False
            .MatchCase = True
            .MatchWholeWord = False
            .MatchWildcards = False
            .MatchSoundsLike = False
            .MatchAllWordForms = False
        End With
        newDocWin.Selection.Find.Execute(Replace:=Microsoft.Office.Interop.Word.WdReplace.wdReplaceAll)

        newDocWin.Selection.HomeKey(Unit:=Microsoft.Office.Interop.Word.WdUnits.wdStory)
        newDocWin.Selection.Find.ClearFormatting()
        newDocWin.Selection.Find.Replacement.ClearFormatting()
        With newDocWin.Selection.Find
            .Text = "^p===  ===^p"
            .Replacement.Text = "^p ^p"
            .Forward = True
            .Wrap = Microsoft.Office.Interop.Word.WdFindWrap.wdFindContinue
            .Format = False
            .MatchCase = True
            .MatchWholeWord = False
            .MatchWildcards = False
            .MatchSoundsLike = False
            .MatchAllWordForms = False
        End With
        newDocWin.Selection.Find.Execute(Replace:=Microsoft.Office.Interop.Word.WdReplace.wdReplaceAll)

        newDocWin.Selection.HomeKey(Unit:=Microsoft.Office.Interop.Word.WdUnits.wdStory)
        newDocWin.Selection.Find.ClearFormatting()
        newDocWin.Selection.Find.Replacement.ClearFormatting()
        With newDocWin.Selection.Find
            .Text = "^p==  ==^p"
            .Replacement.Text = "^p ^p"
            .Forward = True
            .Wrap = Microsoft.Office.Interop.Word.WdFindWrap.wdFindContinue
            .Format = False
            .MatchCase = True
            .MatchWholeWord = False
            .MatchWildcards = False
            .MatchSoundsLike = False
            .MatchAllWordForms = False
        End With
        newDocWin.Selection.Find.Execute(Replace:=Microsoft.Office.Interop.Word.WdReplace.wdReplaceAll)

        newDocWin.Selection.HomeKey(Unit:=Microsoft.Office.Interop.Word.WdUnits.wdStory)
        newDocWin.Selection.Find.ClearFormatting()
        newDocWin.Selection.Find.Replacement.ClearFormatting()
        With newDocWin.Selection.Find
            .Text = "^p=  =^p"
            .Replacement.Text = "^p ^p"
            .Forward = True
            .Wrap = Microsoft.Office.Interop.Word.WdFindWrap.wdFindContinue
            .Format = False
            .MatchCase = True
            .MatchWholeWord = False
            .MatchWildcards = False
            .MatchSoundsLike = False
            .MatchAllWordForms = False
        End With
        newDocWin.Selection.Find.Execute(Replace:=Microsoft.Office.Interop.Word.WdReplace.wdReplaceAll)
    End Sub

    Private Sub MakeWikiItalic()
        newDocWin.Selection.Find.ClearFormatting()
        newDocWin.Selection.Find.Font.Italic = True
        newDocWin.Selection.Find.Replacement.ClearFormatting()
        With newDocWin.Selection.Find
            .Text = ""
            .Replacement.Text = "^39^39^&^39^39"
            .Forward = True
            .Wrap = Microsoft.Office.Interop.Word.WdFindWrap.wdFindContinue
            .Format = True
            .MatchCase = False
            .MatchWholeWord = False
            .MatchWildcards = False
            .MatchSoundsLike = False
            .MatchAllWordForms = False
        End With
        newDocWin.Selection.Find.Execute(Replace:=Microsoft.Office.Interop.Word.WdReplace.wdReplaceAll)
    End Sub

    Private Sub MakeWikiBold()
        newDocWin.Selection.Find.ClearFormatting()
        newDocWin.Selection.Find.Font.Bold = True
        newDocWin.Selection.Find.Replacement.ClearFormatting()
        With newDocWin.Selection.Find
            .Text = ""
            .Replacement.Text = "^39^39^39^&^39^39^39"
            .Forward = True
            .Wrap = Microsoft.Office.Interop.Word.WdFindWrap.wdFindContinue
            .Format = True
            .MatchCase = False
            .MatchWholeWord = False
            .MatchWildcards = False
            .MatchSoundsLike = False
            .MatchAllWordForms = False
        End With
        newDocWin.Selection.Find.Execute(Replace:=Microsoft.Office.Interop.Word.WdReplace.wdReplaceAll)
    End Sub

    Private Sub MakeWikiItalicBold()
        newDocWin.Selection.Find.ClearFormatting()
        newDocWin.Selection.Find.Font.Italic = True
        newDocWin.Selection.Find.Font.Bold = True
        newDocWin.Selection.Find.Replacement.ClearFormatting()
        With newDocWin.Selection.Find
            .Text = ""
            .Replacement.Text = "^39^39^39^39^39^&^39^39^39^39^39"
            .Replacement.Font.Italic = False
            .Replacement.Font.Bold = False
            .Forward = True
            .Wrap = Microsoft.Office.Interop.Word.WdFindWrap.wdFindContinue
            .Format = True
            .MatchCase = False
            .MatchWholeWord = False
            .MatchWildcards = False
            .MatchSoundsLike = False
            .MatchAllWordForms = False
        End With
        newDocWin.Selection.Find.Execute(Replace:=Microsoft.Office.Interop.Word.WdReplace.wdReplaceAll)
    End Sub

    Private Sub MakeWikiDelPagebreaks()
        newDocWin.Selection.Find.ClearFormatting()
        newDocWin.Selection.Find.Replacement.ClearFormatting()
        With newDocWin.Selection.Find
            .Text = "^m"
            .Replacement.Text = ""
            .Forward = True
            .Wrap = Microsoft.Office.Interop.Word.WdFindWrap.wdFindContinue
            .Format = True
            .MatchCase = True
            .MatchWholeWord = False
            .MatchWildcards = False
            .MatchSoundsLike = False
            .MatchAllWordForms = False
        End With
        newDocWin.Selection.Find.Execute(Replace:=Microsoft.Office.Interop.Word.WdReplace.wdReplaceAll)
    End Sub

    Private Sub MakeWikiBookmarks()
        '    Wiki    .
        '     ,        
        Dim allrng As Microsoft.Office.Interop.Word.Range
        Dim thisDoc As Microsoft.Office.Interop.Word.Document
        Dim skip, i As Integer
        Dim linkName, linkText As String
        thisDoc = newDoc
        allrng = newDocWin.Selection.Range
        skip = 0
        For i = 1 To allrng.Hyperlinks.Count
            With allrng.Hyperlinks(1 + skip)
                linkName = .Name
                linkText = .Range.Text
                If LCase(Microsoft.VisualBasic.Left(linkName, 4)) = "www." Or LCase(Microsoft.VisualBasic.Left(linkName, 7)) = "http://" Then
                    If LCase(Microsoft.VisualBasic.Left(linkName, 4)) = "www." Then linkName = "http://" & linkName
                    .Range.Text = "[[" & linkName & "|" & linkText & "]]"
                Else
                    If thisDoc.Bookmarks.Exists(linkName) Then
                        ' replace "_" symbols as they do not work in 1.7.2
                        linkName = linkName.Replace("_", "")
                        .Range.Text = "[[#" & linkName & "|" & linkText & "]]"
                        thisDoc.Bookmarks(linkName).Select()
                        newDocWin.Selection.InsertBefore("<<Anchor(" & linkName & ")>>" & vbCr)
                    Else
                        skip = skip + 1
                    End If
                End If
            End With
        Next i
    End Sub


    Private Sub MakeWikiTableALL()
        '
        '         ( )  Wiki
        '        |   ;
        '     
        '

        Dim rngTemp As Microsoft.Office.Interop.Word.Range
        Dim allrng As Microsoft.Office.Interop.Word.Range
        Dim tableTemp As Microsoft.Office.Interop.Word.Table
        Dim cellLoop As Microsoft.Office.Interop.Word.Cell
        Dim paraTmp As Microsoft.Office.Interop.Word.Paragraph
        Dim i As Integer
        Dim cnt, curCnt As Integer
        curCnt = 1
        allrng = newDocWin.Selection.Range
        cnt = allrng.Tables.Count
        For Each tableTemp In allrng.Tables
            SetStatus("Processing table " & curCnt & " of " & cnt)
            curCnt += 1
            ' replace | symbols (if there are any) with !, otherwise the table will be broken
            tableTemp.Select()
            newDocWin.Selection.Find.ClearFormatting()
            newDocWin.Selection.Find.Replacement.ClearFormatting()
            With newDocWin.Selection.Find
                .Text = "|"
                .Replacement.Text = "!"
                .Forward = True
                .Wrap = Microsoft.Office.Interop.Word.WdFindWrap.wdFindStop
                .Format = False
                .MatchCase = True
                .MatchWholeWord = False
                .MatchWildcards = False
                .MatchSoundsLike = False
                .MatchAllWordForms = False
            End With
            newDocWin.Selection.Find.Execute(Replace:=Microsoft.Office.Interop.Word.WdReplace.wdReplaceAll)

            tableTemp.Range.ListFormat.RemoveNumbers()
            For Each cellLoop In tableTemp.Range.Cells
                i = 1
                If cellLoop.Range.Words.Count = 1 Then cellLoop.Range.InsertAfter(" ")
                While i <= cellLoop.Range.Words.Count
                    If cellLoop.Range.Words(i).Text = vbCr Then
                        '                    cellLoop.Range.Words(i).Text = "; "
                        cellLoop.Range.Words(i).Text = "<<BR>>"
                        '                    i = i + 5
                    End If
                    If cellLoop.Range.Words(i).Text = "|" Then cellLoop.Range.Words(i).Text = ";"
                    i = i + 1
                End While
            Next cellLoop
            rngTemp = tableTemp.ConvertToText(Separator:="|")

            rngTemp.Find.Execute(FindText:="|", ReplaceWith:="||", Replace:=Microsoft.Office.Interop.Word.WdReplace.wdReplaceAll)
            rngTemp.Find.Execute(FindText:="|<", ReplaceWith:="| <", Replace:=Microsoft.Office.Interop.Word.WdReplace.wdReplaceAll)

            For Each paraTmp In rngTemp.Paragraphs
                With paraTmp.Range
                    .InsertBefore("||")
                    .Words(.Words.Count).InsertBefore("||")
                End With
            Next paraTmp
        Next tableTemp
    End Sub

    Private Sub MakeWikiLists()
        Dim para As Microsoft.Office.Interop.Word.Paragraph
        Dim st As String
        Dim i As Integer
        Dim cnt, curCnt As Integer
        curCnt = 1
        cnt = newDoc.Paragraphs.Count
        For Each para In newDoc.Paragraphs
            SetStatus("Looking for lists in paragraph " & curCnt & " of " & cnt)
            curCnt += 1
            If para.Range.ListFormat.ListType = Microsoft.Office.Interop.Word.WdListType.wdListBullet Or para.Range.ListFormat.ListType = Microsoft.Office.Interop.Word.WdListType.wdListPictureBullet Then
                st = "*"
                For i = 1 To para.Range.ListFormat.ListLevelNumber
                    st = " " + st
                Next i
                st = st + " "
                para.Range.InsertBefore(st)
                '      , ..   
                If Microsoft.VisualBasic.Right(para.Range.Text, 7) = "<<BR>>" & vbCr Then para.Range.Find.Execute(FindText:="<<BR>>", ReplaceWith:="", Replace:=Microsoft.Office.Interop.Word.WdReplace.wdReplaceOne, Wrap:=Microsoft.Office.Interop.Word.WdFindWrap.wdFindStop, Forward:=False)
            ElseIf para.Range.ListFormat.ListType = Microsoft.Office.Interop.Word.WdListType.wdListListNumOnly Or para.Range.ListFormat.ListType = Microsoft.Office.Interop.Word.WdListType.wdListSimpleNumbering Or para.Range.ListFormat.ListType = Microsoft.Office.Interop.Word.WdListType.wdListMixedNumbering Or para.Range.ListFormat.ListType = Microsoft.Office.Interop.Word.WdListType.wdListOutlineNumbering Then
                st = "1."
                For i = 1 To para.Range.ListFormat.ListLevelNumber
                    st = " " + st
                Next i
                st = st + " "
                para.Range.InsertBefore(st)
                '      , ..   
                If Microsoft.VisualBasic.Right(para.Range.Text, 7) = "<<BR>>" & vbCr Then para.Range.Find.Execute(FindText:="<<BR>>", ReplaceWith:="", Replace:=Microsoft.Office.Interop.Word.WdReplace.wdReplaceOne, Wrap:=Microsoft.Office.Interop.Word.WdFindWrap.wdFindStop, Forward:=False)
            End If
            para.Range.ListFormat.RemoveNumbers()
        Next para
    End Sub

    Private Sub Button_copy_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_copy.Click
        Clipboard.SetText(TextBox1.Text)
    End Sub

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_about.Click
        'change version number in: Word2Wiki\My Project\AssemblyInfo.vb
        Dim version As String = Application.ProductVersion
        Dim s_version() As String = version.Split(".")
        version = String.Format("{0}.{1}", s_version(0), s_version(1))
        MsgBox("Version: " & version)
    End Sub

End Class
