# -*- coding: iso-8859-1 -*-
"""
    MoinMoin tierraverde theme - thanks to leftsidebar2 by ThomasWaldmann

    @copyright: 2003 by ThomasWaldmann (LinuxWiki:ThomasWaldmann)
    @copyright: 2004 by Jochen Wersdrfer
    @license: GNU GPL, see COPYING for details.
"""

from MoinMoin import config, wikiutil
from classic import Theme as ThemeBase

class Theme(ThemeBase):
    """ This is the tierraverde theme. """

    name = 'tierraverde'

    #stylesheets = ThemeBase.stylesheets + (
    stylesheets = (
        # theme charset         media       basename
        (name,  'iso-8859-1',   'all',      'common'),
        (name,  'iso-8859-1',   'screen',   'screen'),
        (name,  'iso-8859-1',   'print',    'print'),
        )

    def make_iconlink(self, which, d):
        """
        Make a link with an icon

        @param which: icon id (dictionary key)
        @param d: parameter dictionary
        @rtype: string
        @return: html link tag
        """
        page_params, title, icon = config.page_icons_table[which]
        d['title'] = title % d
        d['i18ntitle'] = self.request.getText(d['title'])
        img_src = self.make_icon(icon, d)
        text = "%s&nbsp;%s" % (img_src, d['i18ntitle'])
        return wikiutil.link_tag(self.request, page_params % d, text, attrs='title="%(i18ntitle)s"' % d)

    def iconbar(self, d):
        """
        Assemble the iconbar
        
        @param d: parameter dictionary
        @rtype: string
        @return: iconbar html
        """
        iconbar = []
        if config.page_iconbar and self.request.user.show_toolbar and d['page_name']:
            iconbar.append('<ul id="iconbar">\n')
	    iconbar.append('<div class="iconbarTitle">%s</div>\n' % d.get('iconbar_title', 'Aktionen'))
            icons = config.page_iconbar[:]
            for icon in icons:
                if icon == "up":
                    if d['page_parent_page']:
                        iconbar.append('<li>%s</li>\n' % self.make_iconlink(icon, d))
                elif icon == "subscribe":
                    iconbar.append('<li>%s</li>\n' % self.make_iconlink(
                        ["subscribe", "unsubscribe"][self.request.user.isSubscribedTo([d['page_name']])], d))
                elif icon == "home":
                    if d['page_home_page']:
                        iconbar.append('<li>%s</li>\n' % self.make_iconlink(icon, d))
                else:
                    iconbar.append('<li>%s</li>\n' % self.make_iconlink(icon, d))
            iconbar.append('</ul>\n')
        return ''.join(iconbar)

    def navibar(self, d):
        """
        Assemble the navibar

        @param d: parameter dictionary
        @rtype: string
        @return: navibar html
        """
        html = []
        html.append('<ul id="navibar">\n')
	html.append('<div class="navibarTitle">%s</div>\n' % d.get('navibar_title', 'Wiki'))
        if d['navibar']:
            # Print site name in first field of navibar
            # html.append(('<li>%(site_name)s</li>\n') % d)
            for (link, navi_link) in d['navibar']:
                html.append((
                    '<li><a href="%(link)s">%(navi_link)s</a></li>\n') % {
                        'link': link,
                        'navi_link': navi_link,
                    })
        html.append('</ul>')
        return ''.join(html)

def execute(request):
    return Theme(request)

