// override function of same name in common.js
function show_switch2gui() {
    // Show switch to gui editor link if the browser is compatible
    if (can_use_gui_editor() == false) return;
    // instead of switch2gui, get xswitch2gui
    var switch2gui = document.getElementById('xswitch2gui')
    if (switch2gui) {
        switch2gui.style.display = 'inline';
    }
}


// get corresponding element without leading x in its name and click it
function tickle(x){
    var yName = x.name.slice(1);
    var y = document.getElementsByName(yName);
    y = y[0];
    y.click();
}


// add load event to check for presence of Load Draft button; if so make it visible
addLoadEvent(check_loaddraft);
function check_loaddraft() {
    var el = document.getElementsByName('button_load_draft');
    if (el[0]) {
        el = document.getElementsByName('xbutton_load_draft');
        el[0].style.display = '';
    }
}

// toggle Comments button to show number of comments and show/hide status
// in 1.8 the position of the name tag moved to the LI element
function show_Hide_Comments(showHide) {
    var count = comments.length;
    for (i = 0; i < buttons.length; i++) {
        el = buttons[i];
        if (showHide == 'none') {
            if (el.tagName == 'LI') {
                // is moin 1.8
                el.firstChild.innerHTML = hideButtonLabel;
            } else {
                // is moin 1.7
                el.innerHTML = hideButtonLabel;
            }
        } else {
            if (el.tagName == 'LI') {
                // is moin 1.8
                el.firstChild.innerHTML = showButtonLabel;
            } else {
                // is moin 1.7
                el.innerHTML = showButtonLabel;
            }
        }
    }
}

// find all links pointing to this page and add classname 'thispage' -- executed during load after sidebar is defined
// css will make links to thispage bold
function linksToThisPage() {
    if (document.getElementsByTagName("a") != null) {
        var href = document.location.href ? document.location.href : document.location;
        var thispage = getPageName(href);
        //~ alert(thispage);
        atags = document.getElementsByTagName("a");
        for (var i=0;  i<atags.length;  i++) {
            //~ alert(getPageName(atags[i].href));
            if(getPageName(atags[i].href) == thispage) {
                atags[i].className = "thispage " + atags[i].className;
            }
        }
    }
}
// called by linksToThispage -- return the last 1 or 2 segments of pagename path - links may be absolute or relative
// comparing last 1 or 2 segments is not perfect, but good enough
function getPageName(href) {
    var path = href.split('/');
    return  (path.length<2) ? href : path[path.length-2] + '/' + path[path.length-1];               
}

// IE6 does not understand css sibling selector, delete the chktrivialtop checkbox element and label
// normal themes have an extra trivial change check box on top of edit textarea
function delChkTrivialTop() {
    if (document.getElementById("chktrivialtop")) {
        var n = document.getElementById("chktrivialtop");
        var p = n.parentNode;
        var nxt = n.nextSibling;
        p.removeChild(n);
        p.removeChild(nxt);
    }
}

function showMoreActions() {
    //~ alert('hi');
    var ul = document.getElementById("moreActions");
    ul.style.display = 'block';
    return false;
}
function hideMoreActions() {
    //~ alert('hi');
    var ul = document.getElementById("moreActions");
    ul.style.display = 'none';
    return false;
}



// the 3 following functions were copied from Moin 1.8RC1 - the first 2 are modified

// for long documents with many comments this is expensive to calculate,
// thus we keep it here:
comments = null;
// also save the list of buttons and the formated show and hide button labels 
buttons = null;
showButtonLabel = null;
hideButtonLabel = null;

// this is executed when the user clicks the comments button
// modified 1.8 to change button label by calling show_Hide_comments
function toggleComments() {
    // Toggle visibility of every tag with class "comment"
    show_Hide_Comments(comments[0].style.display);
    for (i = 0; i < comments.length; i++){
        el = comments[i];
        if ( el.style.display != 'none' ) {
            el.style.display = 'none';
        } else {
            el.style.display = '';
        }
    }
}

// this is executed once on page load
// modified 1.8 to change comment button to "+2 Comments" or "-2 Comments"
function show_toggleComments() {
    // Show edit bar item for toggling inline comments only if inline comments exist on the page
    comments = getElementsByClassName('comment', null, document);
    if (comments.length > 0) {
        var count = comments.length;
        buttons = getElementsByClassName('toggleCommentsButton', null, document);
        for (i = 0; i < buttons.length; i++) {
            el = buttons[i];
            el.style.display = '';
            if (el.tagName == 'LI') {
                // is moin 1.8
                showButtonLabel = '+' + count + ' ' + el.firstChild.innerHTML;
                hideButtonLabel = '-' + count + ' ' + el.firstChild.innerHTML;
                // user preferences may set comments on or off; change button label to match
                if (comments[0].style.display == 'none') {
                    el.firstChild.innerHTML = showButtonLabel;
                } else {
                    el.firstChild.innerHTML = hideButtonLabel;
                }
            } else {
                // is moin 1.7
                showButtonLabel = '+' + count + ' ' + el.innerHTML;
                hideButtonLabel = '-' + count + ' ' + el.innerHTML;
                if (comments[0].style.display == 'none') {
                    el.innerHTML = showButtonLabel;
                } else {
                    el.innerHTML = hideButtonLabel;
                }
            }
        }
    }
}

/*  getElementsByClassName
    Developed by Robert Nyman, http://www.robertnyman.com
    Code/licensing: http://code.google.com/p/getelementsbyclassname/ (MIT license)
    Version: 1.0.1
*/  
var getElementsByClassName = function (className, tag, elm){
    if (document.getElementsByClassName) {
        getElementsByClassName = function (className, tag, elm) {
            elm = elm || document;
            var elements = elm.getElementsByClassName(className),
                nodeName = (tag)? new RegExp("\\b" + tag + "\\b", "i") : null,
                returnElements = [],
                current;
            for(var i=0, il=elements.length; i<il; i+=1){
                current = elements[i];
                if(!nodeName || nodeName.test(current.nodeName)) {
                    returnElements.push(current);
                }
            }
            return returnElements;
        };
    }
    else if (document.evaluate) {
        getElementsByClassName = function (className, tag, elm) {
            tag = tag || "*";
            elm = elm || document;
            var classes = className.split(" "),
                classesToCheck = "",
                xhtmlNamespace = "http://www.w3.org/1999/xhtml",
                namespaceResolver = (document.documentElement.namespaceURI === xhtmlNamespace)? xhtmlNamespace : null,
                returnElements = [],
                elements,
                node;
            for(var j=0, jl=classes.length; j<jl; j+=1){
                classesToCheck += "[contains(concat(' ', @class, ' '), ' " + classes[j] + " ')]";
            }
            try {
                elements = document.evaluate(".//" + tag + classesToCheck, elm, namespaceResolver, 0, null);
            }
            catch (e) {
                elements = document.evaluate(".//" + tag + classesToCheck, elm, null, 0, null);
            }
            while ((node = elements.iterateNext())) {
                returnElements.push(node);
            }
            return returnElements;
        };
    }
    else {
        getElementsByClassName = function (className, tag, elm) {
            tag = tag || "*";
            elm = elm || document;
            var classes = className.split(" "),
                classesToCheck = [],
                elements = (tag === "*" && elm.all)? elm.all : elm.getElementsByTagName(tag),
                current,
                returnElements = [],
                match;
            for(var k=0, kl=classes.length; k<kl; k+=1){
                classesToCheck.push(new RegExp("(^|\\s)" + classes[k] + "(\\s|$)"));
            }
            for(var l=0, ll=elements.length; l<ll; l+=1){
                current = elements[l];
                match = false;
                for(var m=0, ml=classesToCheck.length; m<ml; m+=1){
                    match = classesToCheck[m].test(current.className);
                    if (!match) {
                        break;
                    }
                }
                if (match) {
                    returnElements.push(current);
                }
            }
            return returnElements;
        };
    }
    return getElementsByClassName(className, tag, elm);
};


// Experimental code to save javascript variables in cookies and modify page styles on load
//~ function fixedleft_set_cookie (value){
    //~ var cookie_string = "MoinFixedLeft=" + escape ( value );
    //~ var d = new Date();
    //~ var curr_year = d.getFullYear() + 5;
    //~ var expires = new Date ( curr_year, 1, 1 );
    //~ cookie_string += "; expires=" + expires.toGMTString();
    //~ document.cookie = cookie_string;
//~ }
//~ function fixedleft_delete_cookie (){
    //~ var cookie_date = new Date ( );  // current date & time
    //~ cookie_date.setTime ( cookie_date.getTime() - 1 );
    //~ document.cookie = "MoinFixedLeft=; expires=" + cookie_date.toGMTString();
//~ }
//~ function fixedleft_get_cookie (){
    //~ var results = document.cookie.match ( '(^|;) ?' + 'MoinFixedLeft=([^;]*)(;|$)' );
    //~ if ( results )
        //~ return ( unescape ( results[2] ) );
    //~ else
        //~ return null;
//~ }
