# -*- coding: iso-8859-1 -*-
"""
    This is a theme suitable for a casual site visitor.
    The usual wiki navigation links are suppressed, only a sidebar with a login link and 
    links to selected pages are shown.

    To use this theme, you must:
        Modify this progam to customize the sidebar links.
        Toggle the lines marked with @@@ to avoid using fixedleft theme when testing (2 places!).
        Make fixedleftcms the default theme for your wiki.  
        
    Users who are not logged in will receive pages formatted with this theme.
        
    Logged in users will received pages formatted with their selected theme.  If no 
    theme has been selected (or fixedleftcms is the user's selected theme), 
    wiki pages will be formatted with the fixedleft theme.
"""

from MoinMoin import wikiutil
import fixedleft

class Theme(fixedleft.Theme):
    """
        A CMS-like theme with a fixed left margin.
    """

    #~ name = "fixedleft"     # just a reminder that css will be loaded from htdocs/fixedleft/css
    
    def valid_user(self):
        """
        Return true if this is a valid logged in user.  If true is returned, the fixedleft
        theme will be used, not fixedleftcms!
        
        @@@ toggle the tests below for testing/production.
        """
        isValid = 0                                                        # @@@ use this for testing
        #~ isValid = self.request.user.valid and self.request.user.name # @@@ use this for production
        return isValid
    
    def html_head(self, d):
        """ 
        If user is not logged in, add a tiny bit of css to whatever fixedleft creates.
        
        Hides page info from casual visitors.
        """
        head = fixedleft.Theme.html_head(self, d)
        if not self.valid_user():  # user is not logged in, add a bit of optional CSS; more of a demo than useful
            head = u'\n'.join((head,
                    u"""<style type="text/css">
                    <!--
                    p#pageinfo {display: none;}
                    -->
                    </style>
                    """,
                    ))
        return head

    def header(self, d):
        """
        This assembles the sidebar menu.
        
        +++ Modify this method to introduce your wiki topic. +++
            
        @param d: parameter dictionary
        @rtype: string
        @return: page header html
        """
        if self.valid_user():
            return fixedleft.Theme.header(self, d)  # user is logged in, give him the fixedleft theme

        _ = self.request.getText
        html = [
            # Sidebar 
            u'<div id="sidebar">',
            
            # you may find these 2 panels acceptable as is
            self.sitenamepanel(d), # creates logo and wiki name at top of panel
            self.loginpanel(d), # creates login link
            
            #
            # add, change, or delete the panels below to organize your selected wiki pages into topics
            #
            self.firstpanel(d),
            self.secondpanel(d),
            self.editpanel(d), # allows anonymous user to edit WikiSandBox, else returns null string
            
            u'<script type="text/javascript" language="javascript">linksToThisPage()</script>',
            u'</div>', # end of sidebar div
            
            # wiki page content
            u'<div id="wikipagecontent">', # div end is created in footer
            u'<a name="MainWikiPageContent"></a>', # accessibility anchor for screen readers
            # on this theme there is nothing to separate header1 from header2
            self.emit_custom_html(self.cfg.page_header1),
            self.emit_custom_html(self.cfg.page_header2),
            self.msg(d),
            self.startPage(),
            ]
        return u'\n'.join(html)

    def firstpanel(self, d):
        """ 
        Create first example panel.  Modify or delete this example.
        """
        _ = self.request.getText
        html = [
            u'<div class="sidepanel">',
            u'<h2>%s</h2>' %  _("Tutorial"),
            u'<ul>',
            self.makePageLink('HelpOnEditing'),
            self.makePageLink('[[HelpOnLinking|Help on Linking]]'),
            self.makePageLink('[[HelpOnSmileys|Help on Smileys]]'),
            self.popupLink('[[http://www.google.com|Help from google]]'),
            u'</ul>',
            u'</div>'
            ]
        return u'\n'.join(html)
        
    def secondpanel(self, d):
        """ 
        Create second example panel.  Modify or delete this example.
        """
        _ = self.request.getText
        html = [
            u'<div class="sidepanel">',
            u'<h2>%s</h2>' %  _("Practice Editing"),
            u'<ul>',
            self.makePageLink('[[WikiSandBox|Play in Sand Box]]'),
            u'</ul>',
            u'</div>'
            ]
        return u'\n'.join(html)
        
    def editpanel(self, d):
        """ Create edit link if current page is the WikiSandBox."""
        _ = self.request.getText
        # provide edit panel only if user accesses WikiSandBox
        if not _('WikiSandBox') == d['page'].page_name:
            return u''
        html = [
            u'<div class="sidepanel">',
            #~ u'<h2>%s</h2>' %  _("Edit the Page"),
            u'<ul>',
            u'<li>%s</li>' % self.editorLink(d['page']),
            u'</ul>',
            u'</div>'
            ]
        return u'\n'.join(html)

    def sitenamepanel(self,d):
        """
        Create logo and sitename header for left panel. 

        Changes from fixedleft:
            - eliminate page name backlink in UL corner to avoid confusing newbies.
        """
        request = self.request
        html = [
            u'<div class="sidepanel" id="sitenamelogo">',
            self.logo().replace("</a></div>", " %s</a></div>" % self.cfg.sitename),
            u'</div>'
            ]
        return u'\n'.join(html)

    def loginpanel(self, d):
        """ Return a login panel or edit panel if user is logged in.
        
        Required for customized side panel."""
        if self.request.user.valid:
            return self.editpanel(d)
            
        _ = self.request.getText
        html = [
            u'<div class="sidepanel">',
            u'<h2>%s</h2>' %  _("login"),
            self.username(d), # creates xxx?action=Login
            u'</div>'
            ]
        return u'\n'.join(html)

    def popupLink(self,url,windowName='example'):
        """
        Return a hyperlink that will open a popup window.  Precede link with new window icon.
        """
        pageName, linkName = self.splitNavilink(url)
        return '<li>%s</li>\n' % self.editpopup(linkName)

    def makePageLink(self,pageName):
        """
        Return a list item containing a link to a wiki page.
        """
        linkFormat = '<li>%s</li>'
        return linkFormat % self.splitNavilink(pageName)[1]
        

        