# -*- coding: iso-8859-1 -*-
"""
    This is an example of how to sub-class the fixed left theme to create yet another
    theme with a unique set of sidebar panels.
    
    To use this theme, you must:
        Customize the sidebar links by defining fixedleftManagerViewPanels in wikiconfig.py/farmconfig.py.- 
        See http://moinmo.in/ThemeMarket/FixedLeft
"""

from MoinMoin import wikiutil
import fixedleft

class Theme(fixedleft.Theme):
    """
        A CMS-like theme with a left sidebar.
    """

        
    def getViewPanelList(self):
        """return a list of view panels for sidebar."""

        defaultPanelList = (
            'Icon Bar', 
            'Search', 
            'Current Page', 
            'Navigation', 
            #~ 'Page Actions', 
            #~ 'More Actions', 
            'User', 
            'Page Trail', 
            'Page Contents',
            )
        try:
            # @@@ fixedleftmanagerViewPanels should be defined in wikiconfig.py or farmconfig.py
            panelList = self.cfg.fixedleftManagerViewPanels
        except:
            panelList = defaultPanelList
        return panelList

    # Uncomment this method if you need a unique set of edit panels
    #~ def getEditPanelList(self):
        #~ """return a list of edit panels for sidebar."""
        #~ defaultPanelList = ('Current Page', 'Editor Controls', 'Editor Help', 'Editor Hints', 'Page Contents')
        #~ try:
            #~ panelList = self.cfg.fixedleftManagerEditPanels
        #~ except:
            #~ panelList = defaultPanelList
        #~ return panelList
