  
    # a starting point for defining custom panels for fixedleft, fixedleftcms, and fixedleftmanager
    # add this to the end of wikiconfig.py or farmconfig.py
    
    # these are defaults in fixed left theme, each item will generate a pre-defined panel
    fixedleftViewPanels = ('Search', 'Current Page', # 'Icon Bar',
        'Navigation', 'Page Actions', 'More Actions', 'User', 
        'Page Trail', 'Page Contents',
        )
    fixedleftEditPanels = ('Current Page', 'Editor Controls', 
        'Editor Help', 'Editor Hints', 'Page Contents',)
    
    # define a sample panel
    myCustomPanel = ('Where to Get Help', # panel heading
        'HelpOnNavigation', # include a link to HelpOnNavigation page
        '[[HelpOnImages|Help On Images]]', # include a link to HelpOnImages page
        '$[[http://www.google.com|Google]]',) # leading $ will open a new window to display google page
        
    # define another sample panel;  standard search panel contents, but heading changed to "Search My Wiki"
    myCustomSearchPanel = ('Search My Wiki','Search')
    
    # define viewing sidebar for fixedleftcms theme
    fixedleftCMSViewPanels = (myCustomPanel, 'User', myCustomSearchPanel, 
        'Navigation', 'Page Contents')
    # editing is not expected in CMS theme, so there is no need for a fixedleftCMSEditPanels
    
    # define a viewing sidebar for fixedleftmanager 
    fixedleftManagerViewPanels = ('Icon Bar',) + fixedleftCMSViewPanels
    # if manager edits a page, the edit sidebar will use fixedleftEditPanels;  Or create a unique sidebar:
    # fixedleftManagerEditPanels = (????, ???)
    
    # you probably do not want Icon Bar and Page Actions together
    # Advantage of Icon Bar is it saves vertical space in sidebar and has more choices than Page Actions
    
    # possible choices for Icon Bar in desired sequence
    # this overrides entry in /config/multiconfig.py
    page_iconbar = [
        # "diff",
        "edit", 
        "info", 
        "subscribe",  # either subscribe or unsubscribe
        "quicklink",  # either quicklink or quickunlink
        "attachments", 
        "raw", 
        "refresh", 
        "spellcheck", 
        # "slideshow", 
        "createpdf", # see /ActionMarket/PdfAction or CreatePdfDocument
        # "xml",
        # "print",
        # "up",
        ]
    
    # list of icons that may appear in Icon Bar, valid values are only those in page_icons_table. Used in Classic theme
    # this overrides entry in MoinMoin/config/multiconfig.py
    page_icons_table = {
        # key           pagekey, querystr dict, title, icon-key
        'diff': ('page', {'action': 'diff'}, _("Diffs"), "diff"),
        'info': ('page', {'action': 'info'}, _("Info"), "info"),
        'edit': ('page', {'action': 'edit'}, _("Edit"), "edit"),
        'unsubscribe': ('page', {'action': 'unsubscribe'}, _("UnSubscribe"), "unsubscribe"),
        'subscribe': ('page', {'action': 'subscribe'}, _("Subscribe"), "subscribe"),
        'quicklink': ('page', {'action': 'quicklink'}, _("Add Quick Link"), "quicklink"),
        'quickunlink': ('page', {'action': 'quickunlink'}, _("Remove Quick Link"), "quickunlink"),
        'spellcheck': ('page', {'action': 'SpellCheck'}, _("Spell Check"), "spellcheck"),
        'slideshow': ('page', {'action': 'SlideShow'}, _("Slide Show"), "projection"),
        'createpdf': ('page', {'action': 'CreatePdfDocument'}, _("Create PDF"), "pdf"),
        'attachments': ('page', {'action': 'AttachFile'}, _("Manage Attachments"), "attach"),
        'raw': ('page', {'action': 'raw'}, _("Raw Text"), "raw"),
        'xml': ('page', {'action': 'show', 'mimetype': 'text/xml'}, _("XML"), "xml"),
        'print': ('page', {'action': 'print'}, _("Print"), "print"),
        #~ 'view': ('page', {}, _("View"), "view"), # refresh uses same icon and produces similar and more useful result
        'refresh': ('page', {'action': 'refresh'}, _("Refresh Cache"), "view"),
        'up': ('page_parent_page', {}, _("Up"), "up"),
        }
        
    del _