# -*- coding: iso-8859-1 -*-
"""
    MoinMoin - MobiHeavy
    Optimized MoinMoin Wiki for Mobile Devices like Google Android.
    (The source code is mostly taken from the "Moderne Theme by Nir Soffer and Thomas Waldmann)

    @copyright: 2009 Marcel Haefner (http://moinmo.in/MarcelH%C3%A4fner)
    @license: GNU GPL, see http://rock.heavy.ch/wiki/COPYING for details.
"""

from MoinMoin.theme import ThemeBase

class Theme(ThemeBase):

    name = "mobiheavy"

    def onlyloggedin(method):
        """ decorator that returns empty string for not logged-in users,
            otherwise it calls the decorated method
        """
        return lambda self, *args, **kwargs: (
            self.request.user.valid and self.request.user.name and method(self, *args, **kwargs)
            or
            ''
            )

    def header(self, d, **kw):
        """ Assemble wiki header

        @param d: parameter dictionary
        @rtype: unicode
        @return: page header html
        """
        html = [
            # Pre header custom html
            self.emit_custom_html(self.cfg.page_header1),

            # Header
            u'<div id="header">',
            self.logo(),
            self.navibar(d),
            #self.searchform(d),
            # u'<hr>',
            # self.username(d),
            self.trail(d),
            # u'<hr>',
            #self.editbar(d),
            self.msg(d),
            u'<hr>',
            self.interwiki(d),
            self.title(d),
            u'</div>',

            # Post header custom html (not recommended)
            self.emit_custom_html(self.cfg.page_header2),

            # Start of page
            self.startPage(),
        ]
        return u'\n'.join(html)

    def editorheader(self, d, **kw):
        """ Assemble wiki header for editor

        @param d: parameter dictionary
        @rtype: unicode
        @return: page header html
        """
        html = [
            # Pre header custom html
            self.emit_custom_html(self.cfg.page_header1),

            # Header
            u'<div id="header">',
            self.title(d),
            self.msg(d),
            u'</div>',

            # Post header custom html (not recommended)
            self.emit_custom_html(self.cfg.page_header2),

            # Start of page
            self.startPage(),
        ]
        return u'\n'.join(html)

    def footer(self, d, **keywords):
        """ Assemble wiki footer

        @param d: parameter dictionary
        @keyword ...:...
        @rtype: unicode
        @return: page footer html
        """
        page = d['page']
        html = [
            # End of page
            self.pageinfo(page),
            self.endPage(),

            # Pre footer custom html (not recommended!)
            self.emit_custom_html(self.cfg.page_footer1),
            self.editbar(d),
            self.username(d),
            self.searchform(d),
            # Footer
            u'<div id="footer">',
            # self.editbar(d),
            self.credits(d),
            self.showversion(d, **keywords),
            u'</div>',

            # Post footer custom html
            self.emit_custom_html(self.cfg.page_footer2),
            ]
        return u'\n'.join(html)


    pageinfo = onlyloggedin(ThemeBase.pageinfo)
    editbar = onlyloggedin(ThemeBase.editbar)


def execute(request):
    """
    Generate and return a theme object

    @param request: the request object
    @rtype: MoinTheme
    @return: Theme object
    """
    return Theme(request)

