# -*- coding: iso-8859-1 -*-
"""
    MoinMoin Siplemente theme

    Copyright...
"""

from MoinMoin import wikiutil
from MoinMoin.Page import Page
from MoinMoin.theme import ThemeBase

class Theme(ThemeBase):

    name = "simplemente"

    def wikipanel(self, d):
        """ Create wiki panel """
        _ = self.request.getText
        html = [
            u'<div class="sidepanel">',
            self.navibar(d),
            u'</div>',
            ]
        return u'\n'.join(html)
    
    def pagepanel(self, d):
        """ Create page panel """
        _ = self.request.getText
        if self.shouldShowEditbar(d['page']):
            html = [
                self.editbar(d),
                ]
            return u'\n'.join(html)
        return ''   
        
    def userpanel(self, d):
        """ Create user panel """
        _ = self.request.getText

        trail = self.trail(d)
        if trail:
            trail = u'<h2>%s</h2>\n' % _("Recently viewed pages") + trail

        html = [
            u'<div class="sidepanel">',
            self.username(d),
            trail,
            u'</div>'
            ]
        return u'\n'.join(html)

    def header(self, d):
        """
        Assemble page header
        
        @param d: parameter dictionary
        @rtype: string
        @return: page header html
        """
        _ = self.request.getText

        html = [
            # Custom html above header
            self.emit_custom_html(self.cfg.page_header1),
			
            # Skip links
            u'<div id="help">',
            u'<ul>',
            u'<li class="help"><a href="#content">%s</a></li>' % _('Jump directly to the page content'),
            u'<li class="help"><a href="#edit">%s</a></li>' % _('to the edit and actions menu'),
            u'<li class="help"><a href="#nav">%s</a></li>' % _('to the navigation menu'),
            u'<li class="help"><a href="#user">%s</a></li>' % _('or to the personalization menu'),
            u'</ul>',
            u'</div>',
   
            # Custom html below header (not recomended!)
            self.emit_custom_html(self.cfg.page_header2),

            # Page
            #u'<h1 class="screenreader_info"><a name="content">%s</a></h1>' % _('Content'),
            u'<a name="content"></a>',
            self.msg(d),
            self.startPage(),
            self.title(d),
	    u'</div>',     
            ]
        return u'\n'.join(html)

    def searchform(self, d):
        """ assemble HTML code for the search forms

        Changed: div removed and linbreak added for Simplemente. Searchbox formatting now done by
                 CSS
        
        @param d: parameter dictionary
        @rtype: unicode
        @return: search form html
        """
        _ = self.request.getText
        form = self.request.form
        updates = {
            'search_label': _('Search:'),
            'search_value': wikiutil.escape(form.get('value', [''])[0], 1),
            'search_full_label': _('Text', formatted=False),
            'search_title_label': _('Titles', formatted=False),
            }
        d.update(updates)

        html = u'''
<form id="searchform" method="get" action="">
<input type="hidden" name="action" value="fullsearch">
<input type="hidden" name="context" value="180">
<label for="searchinput">%(search_label)s</label>
<input id="searchinput" type="text" name="value" value="%(search_value)s" size="20"
    onfocus="searchFocus(this)" onblur="searchBlur(this)"
    onkeyup="searchChange(this)" onchange="searchChange(this)" alt="Search">
<br> 
<input id="titlesearch" name="titlesearch" type="submit"
    value="%(search_title_label)s" alt="Search Titles">
<input id="fullsearch" name="fullsearch" type="submit"
    value="%(search_full_label)s" alt="Search Full Text">
</form>
<script type="text/javascript">
<!--// Initialize search form
var f = document.getElementById('searchform');
f.getElementsByTagName('label')[0].style.display = 'none';
var e = document.getElementById('searchinput');
searchChange(e);
searchBlur(e);
//-->
</script>
''' % d
        return html

    def credits(self, d, **keywords):
        """ Create credits html from credits list """

       
        _credits = u'<br><div id="creditos"><!--Creative Commons License--><a href="http://simplementewiki.org">SimpleMenteW\
        iki</a> est&aacute; licenciado bajo una <a rel="license" href="http://creativecommons.org/licenses/by-sa/2.5/deed.es_AR"\
        >Licencia Creative Commons Atribuci&oacute;n-Compartir Obras Derivadas Igual 2.5 </a><br/><img alt="Creative Commons Lic\
        ense" style="border-width: 0" src="http://creativecommons.org/images/public/cc-wiki.png"/></a>.</div><!--/Creative Commo\
        ns License--><!-- <rdf:RDF xmlns="http://web.resource.org/cc/" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="ht\
        tp://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"> <Work rdf:about=""> <lice\
        nse rdf:resource="http://creativecommons.org/licenses/by-sa/2.5/" /> </Work> <License rdf:about="http://creativecommons.\
        org/licenses/by-sa/2.5/"><permits rdf:resource="http://web.resource.org/cc/Reproduction"/><permits rdf:resource="http://\
        web.resource.org/cc/Distribution"/><requires rdf:resource="http://web.resource.org/cc/Notice"/><requires rdf:resource="h\
        ttp://web.resource.org/cc/Attribution"/><permits rdf:resource="http://web.resource.org/cc/DerivativeWorks"/><requires rd\
        f:resource="http://web.resource.org/cc/ShareAlike"/></License></rdf:RDF> -->'
        
        if isinstance(self.cfg.page_credits, (list, tuple)):
            items = ['<li>%s</li>' % i for i in self.cfg.page_credits]
            html = '<ul id="credits">\n%s\n</ul>%s\n' % (''.join(items), _credits)
        else:
            # Old config using string, output as is
            html = self.cfg.page_credits + _credits
        return html


    def footer(self, d, **keywords):
        """ Assemble page footer
        
        @param d: parameter dictionary
        @keyword ...:...
        @rtype: string
        @return: page footer html
        """
        _ = self.request.getText
        page = d['page']
        html = [

            # Page end
            # Used to extend the page to the bottom of the sidebar
            u'<div id="pagebottom"></div>',
            self.pageinfo(page),
            #u'<h1 class="screenreader_info"><a name="edit">%s</a></h1>' % _("Edit and actions menu"),
            u'<a name="edit"></a>',
            self.editbar(d),
            self.credits(d),
            self.endPage(),
            
            # Sidebar
            u'<div id="sidebar">',
	         # Header
            u'<div id="header">',
            self.logo(),
            u'</div>',
 	    #u'<h1 class="screenreader_info"><a name="nav">%s</a></h1>' % _('Navigation'),
            u'<a name="nav"></a>',
            self.wikipanel(d),
            self.searchform(d),
	    #u'<h1 class="screenreader_info"><a name="user">%s</a></h1>' % _('Personalization'),
            u'<a name="user"></a>',
            self.userpanel(d),
            u'</div>',

            			
            # Custom html above footer
            self.emit_custom_html(self.cfg.page_footer1),
            
            # And bellow
            self.emit_custom_html(self.cfg.page_footer2),

            # Google analytics stuff
            u'<script src="http://www.google-analytics.com/urchin.js" type="text/javascript">',
            u'</script>',
            u'<script type="text/javascript">',
            u'_uacct = "your-code-here";',
            u'urchinTracker();',
            u'</script>',
            ]
        return u'\n'.join(html)


def execute(request):
    """
    Generate and return a theme object
        
    @param request: the request object
    @rtype: MoinTheme
    @return: Theme object
    """
    return Theme(request)

