# -*- coding: iso-8859-1 -*-
"""
    MoinMoin - steel theme

    @copyright: 2005 by Nedko Arnaudov
    @license: GNU GPL, see COPYING for details.
"""

from MoinMoin.theme import ThemeBase
from MoinMoin import wikiutil
from MoinMoin.Page import Page

class Theme(ThemeBase):

    name = "steel"

    def wikipanel(self, d):
        """ Create wiki panel """
        _ = self.request.getText
        html = [
            u'<div class="sidepanel">',
            u'<h1>%s</h1>' % _("Wiki"),
            self.navibar(d),
            u'</div>',
            ]
        return u'\n'.join(html)
    
    def pagepanel(self, d):
        """ Create page panel """
        _ = self.request.getText
        if self.shouldShowEditbar(d['page']):
            html = [
                u'<div class="sidepanel">',
                u'<h1>%s</h1>' % _("Page"),
                self.editbar(d),
                u'</div>',
                ]
            return u'\n'.join(html)
        return ''   
        
    def userpanel(self, d):
        """ Create user panel """
        _ = self.request.getText

        html = [
            u'<div class="sidepanel">',
            u'<h1>%s</h1>' %  _("User"),
            self.username(d),
            u'</div>'
            ]
        return u'\n'.join(html)

    def trailpanel(self, d):
        """ Create trail panel """
        _ = self.request.getText

        html = [
            u'<div class="sidepanel">',
            u'<h1>%s</h1>' %  _("Trail"),
            self.trail(d),
            u'</div>'
            ]
        return u'\n'.join(html)

    def header(self, d, **kw):
        """ Assemble wiki header
        
        @param d: parameter dictionary
        @rtype: unicode
        @return: page header html
        """
        html = [
            # Pre header custom html
            #self.emit_custom_html(self.cfg.page_header1),
            
            # Header
            #u'<div id="header">',
            #self.logo(),
            #self.searchform(d),
            #u'<div id="locationline">',
            #self.interwiki(d),
            #self.title(d),
            #u'</div>',
            #u'<hr id="pageline">',
            #u'<div id="pageline"><hr style="display:none;"></div>',
            #self.msg(d),
            #self.editbar(d),
            #u'</div>',
            
            # Post header custom html (not recommended)
            #self.emit_custom_html(self.cfg.page_header2),
            
            # Sidebar
            u'<div id="sidebar">',
            self.wikipanel(d),
            self.trailpanel(d),
            self.userpanel(d),
            self.pagepanel(d),
            u'</div>',

            # Start of page
            self.startPage(),
            self.msg(d),
        ]
        return u'\n'.join(html)

    def editorheader(self, d, **kw):
        """ Assemble wiki header for editor
        
        @param d: parameter dictionary
        @rtype: unicode
        @return: page header html
        """
        html = [
            # Pre header custom html
            #self.emit_custom_html(self.cfg.page_header1),
            
            # Sidebar
            u'<div id="sidebar">',
            self.wikipanel(d),
            self.trailpanel(d),
            self.userpanel(d),
            self.pagepanel(d),
            u'<div class="sidebox">',
            self.msg(d),
            u'</div>',
            u'<div class="sidebox">',
            self.title(d),
            u'</div>',
            u'</div>',

            # Post header custom html (not recommended)
            #self.emit_custom_html(self.cfg.page_header2),
            
            # Start of page
            self.startPage(),
        ]
        return u'\n'.join(html)

    def footer(self, d, **keywords):
        """ Assemble wiki footer
        
        @param d: parameter dictionary
        @keyword ...:...
        @rtype: unicode
        @return: page footer html
        """
        page = d['page']
        html = [
            # End of page
            self.pageinfo(page),
            self.endPage(),
            
            # Pre footer custom html (not recommended!)
            #self.emit_custom_html(self.cfg.page_footer1),
            
            # Footer
            #u'<div id="footer">',
            #self.editbar(d),
            #self.credits(d),
            #self.showversion(d, **keywords),
            #u'</div>',
            
            # Post footer custom html
            #self.emit_custom_html(self.cfg.page_footer2),
            ]
        return u'\n'.join(html)

    def logo(self):
        """ Assemble logo with link to front page

        The logo contain an image and or text or any html markup the
        admin inserted in the config file. Everything it enclosed inside
        a div with id="logo".
        
        @param d: parameter dictionary
        @rtype: unicode
        @return: logo html
        """
        html = u''
        if self.cfg.logo_string:
            pagename = wikiutil.getFrontPage(self.request).page_name
            pagename = wikiutil.quoteWikinameURL(pagename)
            logo = wikiutil.link_tag(self.request, pagename)
            html = u'''<div id="logo">%s</div>''' % logo
        return html

    def trail(self, d):
        """ Assemble page trail
        
        @param d: parameter dictionary
        @rtype: unicode
        @return: trail html
        """
        request = self.request
        user = request.user
        html = ''
        if user.valid and user.show_page_trail:
            trail = user.getTrail()
            if trail:
                items = []
                for pagename in trail:
                    try:
                        interwiki, page = pagename.split(":", 1)
                        # Items in trail are saved as valid interwiki
                        # links, using _ for spaces.
                        page = page.replace('_', ' ')
                        if request.cfg.interwikiname != interwiki:
                            link = (self.request.formatter.interwikilink(
                                True, interwiki, page) +
                                    self.shortenPagename(page) +
                                    self.request.formatter.interwikilink(False))
                            items.append('<li>%s</li>' % link)
                            continue
                        else:
                            pagename = page
                            
                    except ValueError:
                        pass
                    page = Page(request, pagename)
                    title = page.split_title(request)
                    title = self.shortenPagename(title)
                    link = page.link_to(request, title)
                    items.insert(0, '<li>%s</li>' % link)
                html = '''
<ul id="pagetrail">
%s
</ul>''' % ''.join(items)
        return html

def execute(request):
    """
    Generate and return a theme object
        
    @param request: the request object
    @rtype: MoinTheme
    @return: Theme object
    """
    return Theme(request)

